// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x00000000u, ImmutableString("radians(00B").mangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("radians(10B").mangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("radians(20B").mangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("radians(30B").mangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("degrees(00B").mangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("degrees(10B").mangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("degrees(20B").mangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("degrees(30B").mangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("sin(00B").mangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("sin(10B").mangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("sin(20B").mangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("sin(30B").mangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("cos(00B").mangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("cos(10B").mangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("cos(20B").mangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("cos(30B").mangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("tan(00B").mangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("tan(10B").mangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("tan(20B").mangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("tan(30B").mangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("asin(00B").mangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("asin(10B").mangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("asin(20B").mangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("asin(30B").mangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("acos(00B").mangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("acos(10B").mangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("acos(20B").mangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("acos(30B").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("atan(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("atan(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("atan(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("atan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("atan(00B").mangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("atan(10B").mangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("atan(20B").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("atan(30B").mangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("sinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("sinh(10B").mangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("sinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("sinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("cosh(00B").mangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("cosh(10B").mangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("cosh(20B").mangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("cosh(30B").mangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("tanh(00B").mangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("tanh(10B").mangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("tanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("tanh(30B").mangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("asinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("asinh(10B").mangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("asinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("asinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("acosh(00B").mangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("acosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("acosh(20B").mangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("acosh(30B").mangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("atanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("atanh(10B").mangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("atanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("atanh(30B").mangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("pow(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("pow(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("pow(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("pow(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("exp(00B").mangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("exp(10B").mangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("exp(20B").mangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("exp(30B").mangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("log(00B").mangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("log(10B").mangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("log(20B").mangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("log(30B").mangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("exp2(00B").mangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("exp2(10B").mangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("exp2(20B").mangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("exp2(30B").mangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("log2(00B").mangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("log2(10B").mangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("log2(20B").mangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("log2(30B").mangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("sqrt(00B").mangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("sqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("sqrt(20B").mangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("sqrt(30B").mangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("sqrt(00C").mangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("sqrt(10C").mangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("sqrt(20C").mangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("sqrt(30C").mangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("inversesqrt(00B").mangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("inversesqrt(10B").mangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("inversesqrt(20B").mangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("inversesqrt(30B").mangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("inversesqrt(00C").mangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("inversesqrt(10C").mangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("inversesqrt(20C").mangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("inversesqrt(30C").mangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("abs(00B").mangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("abs(10B").mangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("abs(20B").mangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("abs(30B").mangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("abs(00D").mangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("abs(10D").mangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("abs(20D").mangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("abs(30D").mangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("abs(00C").mangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("abs(10C").mangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("abs(20C").mangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("abs(30C").mangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("sign(00B").mangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("sign(10B").mangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("sign(20B").mangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("sign(30B").mangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("sign(00D").mangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("sign(10D").mangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("sign(20D").mangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("sign(30D").mangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("sign(00C").mangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("sign(10C").mangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("sign(20C").mangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("sign(30C").mangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("floor(00B").mangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("floor(10B").mangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("floor(20B").mangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("floor(30B").mangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("floor(00C").mangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("floor(10C").mangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("floor(20C").mangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("floor(30C").mangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("trunc(00B").mangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("trunc(10B").mangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("trunc(20B").mangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("trunc(30B").mangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("trunc(00C").mangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("trunc(10C").mangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("trunc(20C").mangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("trunc(30C").mangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("round(00B").mangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("round(10B").mangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("round(20B").mangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("round(30B").mangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("round(00C").mangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("round(10C").mangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("round(20C").mangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("round(30C").mangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("roundEven(00B").mangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("roundEven(10B").mangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("roundEven(20B").mangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("roundEven(30B").mangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("roundEven(00C").mangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("roundEven(10C").mangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("roundEven(20C").mangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("roundEven(30C").mangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("ceil(00B").mangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("ceil(10B").mangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("ceil(20B").mangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("ceil(30B").mangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("ceil(00C").mangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("ceil(10C").mangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("ceil(20C").mangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("ceil(30C").mangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("fract(00B").mangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("fract(10B").mangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("fract(20B").mangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("fract(30B").mangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("fract(00C").mangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("fract(10C").mangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("fract(20C").mangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("fract(30C").mangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("mod(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("mod(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("mod(20B00B").mangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("mod(30B00B").mangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("mod(10B10B").mangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("mod(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("mod(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("mod(00C00C").mangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("mod(10C00C").mangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("mod(20C00C").mangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("mod(30C00C").mangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("mod(10C10C").mangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("mod(20C20C").mangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("mod(30C30C").mangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("min(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("min(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("min(20B00B").mangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("min(30B00B").mangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("min(10B10B").mangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("min(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("min(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("min(00C00C").mangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("min(10C10C").mangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("min(20C20C").mangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("min(30C30C").mangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("min(10C00C").mangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("min(20C00C").mangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("min(30C00C").mangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("min(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("min(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("min(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("min(30D30D").mangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("min(10D00D").mangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("min(20D00D").mangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("min(30D00D").mangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("min(00E00E").mangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("min(10E10E").mangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("min(20E20E").mangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("min(30E30E").mangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("min(10E00E").mangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("min(20E00E").mangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("min(30E00E").mangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("max(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("max(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("max(20B00B").mangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("max(30B00B").mangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("max(10B10B").mangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("max(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("max(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000d9u, ImmutableString("max(00C00C").mangledNameHash());
    ASSERT_EQ(0x000000dau, ImmutableString("max(10C10C").mangledNameHash());
    ASSERT_EQ(0x000000dbu, ImmutableString("max(20C20C").mangledNameHash());
    ASSERT_EQ(0x000000dcu, ImmutableString("max(30C30C").mangledNameHash());
    ASSERT_EQ(0x000000ddu, ImmutableString("max(10C00C").mangledNameHash());
    ASSERT_EQ(0x000000deu, ImmutableString("max(20C00C").mangledNameHash());
    ASSERT_EQ(0x000000dfu, ImmutableString("max(30C00C").mangledNameHash());
    ASSERT_EQ(0x000000e0u, ImmutableString("max(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000e1u, ImmutableString("max(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000e2u, ImmutableString("max(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000e3u, ImmutableString("max(30D30D").mangledNameHash());
    ASSERT_EQ(0x000000e4u, ImmutableString("max(10D00D").mangledNameHash());
    ASSERT_EQ(0x000000e5u, ImmutableString("max(20D00D").mangledNameHash());
    ASSERT_EQ(0x000000e6u, ImmutableString("max(30D00D").mangledNameHash());
    ASSERT_EQ(0x000000e7u, ImmutableString("max(00E00E").mangledNameHash());
    ASSERT_EQ(0x000000e8u, ImmutableString("max(10E10E").mangledNameHash());
    ASSERT_EQ(0x000000e9u, ImmutableString("max(20E20E").mangledNameHash());
    ASSERT_EQ(0x000000eau, ImmutableString("max(30E30E").mangledNameHash());
    ASSERT_EQ(0x000000ebu, ImmutableString("max(10E00E").mangledNameHash());
    ASSERT_EQ(0x000000ecu, ImmutableString("max(20E00E").mangledNameHash());
    ASSERT_EQ(0x000000edu, ImmutableString("max(30E00E").mangledNameHash());
    ASSERT_EQ(0x000000eeu, ImmutableString("clamp(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000efu, ImmutableString("clamp(10B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000f0u, ImmutableString("clamp(20B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000f1u, ImmutableString("clamp(30B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000f2u, ImmutableString("clamp(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000000f3u, ImmutableString("clamp(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000000f4u, ImmutableString("clamp(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000000f5u, ImmutableString("clamp(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000f6u, ImmutableString("clamp(10C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000f7u, ImmutableString("clamp(20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000f8u, ImmutableString("clamp(30C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000f9u, ImmutableString("clamp(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x000000fau, ImmutableString("clamp(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x000000fbu, ImmutableString("clamp(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x000000fcu, ImmutableString("clamp(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000fdu, ImmutableString("clamp(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000feu, ImmutableString("clamp(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000ffu, ImmutableString("clamp(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000100u, ImmutableString("clamp(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x00000101u, ImmutableString("clamp(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x00000102u, ImmutableString("clamp(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000103u, ImmutableString("clamp(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000104u, ImmutableString("clamp(10E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000105u, ImmutableString("clamp(20E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000106u, ImmutableString("clamp(30E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000107u, ImmutableString("clamp(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000108u, ImmutableString("clamp(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x00000109u, ImmutableString("clamp(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x0000010au, ImmutableString("mix(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000010bu, ImmutableString("mix(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x0000010cu, ImmutableString("mix(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x0000010du, ImmutableString("mix(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x0000010eu, ImmutableString("mix(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000010fu, ImmutableString("mix(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000110u, ImmutableString("mix(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000111u, ImmutableString("mix(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x00000112u, ImmutableString("mix(10C10C00C").mangledNameHash());
    ASSERT_EQ(0x00000113u, ImmutableString("mix(20C20C00C").mangledNameHash());
    ASSERT_EQ(0x00000114u, ImmutableString("mix(30C30C00C").mangledNameHash());
    ASSERT_EQ(0x00000115u, ImmutableString("mix(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x00000116u, ImmutableString("mix(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x00000117u, ImmutableString("mix(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x00000118u, ImmutableString("mix(00B00B00F").mangledNameHash());
    ASSERT_EQ(0x00000119u, ImmutableString("mix(10B10B10F").mangledNameHash());
    ASSERT_EQ(0x0000011au, ImmutableString("mix(20B20B20F").mangledNameHash());
    ASSERT_EQ(0x0000011bu, ImmutableString("mix(30B30B30F").mangledNameHash());
    ASSERT_EQ(0x0000011cu, ImmutableString("mix(00C00C00F").mangledNameHash());
    ASSERT_EQ(0x0000011du, ImmutableString("mix(10C10C10F").mangledNameHash());
    ASSERT_EQ(0x0000011eu, ImmutableString("mix(20C20C20F").mangledNameHash());
    ASSERT_EQ(0x0000011fu, ImmutableString("mix(30C30C30F").mangledNameHash());
    ASSERT_EQ(0x00000120u, ImmutableString("mix(00D00D00F").mangledNameHash());
    ASSERT_EQ(0x00000121u, ImmutableString("mix(10D10D10F").mangledNameHash());
    ASSERT_EQ(0x00000122u, ImmutableString("mix(20D20D20F").mangledNameHash());
    ASSERT_EQ(0x00000123u, ImmutableString("mix(30D30D30F").mangledNameHash());
    ASSERT_EQ(0x00000124u, ImmutableString("mix(00E00E00F").mangledNameHash());
    ASSERT_EQ(0x00000125u, ImmutableString("mix(10E10E10F").mangledNameHash());
    ASSERT_EQ(0x00000126u, ImmutableString("mix(20E20E20F").mangledNameHash());
    ASSERT_EQ(0x00000127u, ImmutableString("mix(30E30E30F").mangledNameHash());
    ASSERT_EQ(0x00000128u, ImmutableString("mix(00F00F00F").mangledNameHash());
    ASSERT_EQ(0x00000129u, ImmutableString("mix(10F10F10F").mangledNameHash());
    ASSERT_EQ(0x0000012au, ImmutableString("mix(20F20F20F").mangledNameHash());
    ASSERT_EQ(0x0000012bu, ImmutableString("mix(30F30F30F").mangledNameHash());
    ASSERT_EQ(0x0000012cu, ImmutableString("step(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000012du, ImmutableString("step(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000012eu, ImmutableString("step(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000012fu, ImmutableString("step(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000130u, ImmutableString("step(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000131u, ImmutableString("step(00B20B").mangledNameHash());
    ASSERT_EQ(0x00000132u, ImmutableString("step(00B30B").mangledNameHash());
    ASSERT_EQ(0x00000133u, ImmutableString("step(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000134u, ImmutableString("step(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000135u, ImmutableString("step(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000136u, ImmutableString("step(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000137u, ImmutableString("step(00C10C").mangledNameHash());
    ASSERT_EQ(0x00000138u, ImmutableString("step(00C20C").mangledNameHash());
    ASSERT_EQ(0x00000139u, ImmutableString("step(00C30C").mangledNameHash());
    ASSERT_EQ(0x0000013au, ImmutableString("smoothstep(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x0000013bu, ImmutableString("smoothstep(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x0000013cu, ImmutableString("smoothstep(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x0000013du, ImmutableString("smoothstep(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x0000013eu, ImmutableString("smoothstep(00C00C10C").mangledNameHash());
    ASSERT_EQ(0x0000013fu, ImmutableString("smoothstep(00C00C20C").mangledNameHash());
    ASSERT_EQ(0x00000140u, ImmutableString("smoothstep(00C00C30C").mangledNameHash());
    ASSERT_EQ(0x00000141u, ImmutableString("smoothstep(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000142u, ImmutableString("smoothstep(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000143u, ImmutableString("smoothstep(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000144u, ImmutableString("smoothstep(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000145u, ImmutableString("smoothstep(00B00B10B").mangledNameHash());
    ASSERT_EQ(0x00000146u, ImmutableString("smoothstep(00B00B20B").mangledNameHash());
    ASSERT_EQ(0x00000147u, ImmutableString("smoothstep(00B00B30B").mangledNameHash());
    ASSERT_EQ(0x00000148u, ImmutableString("modf(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000149u, ImmutableString("modf(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000014au, ImmutableString("modf(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000014bu, ImmutableString("modf(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000014cu, ImmutableString("modf(00C00C").mangledNameHash());
    ASSERT_EQ(0x0000014du, ImmutableString("modf(10C10C").mangledNameHash());
    ASSERT_EQ(0x0000014eu, ImmutableString("modf(20C20C").mangledNameHash());
    ASSERT_EQ(0x0000014fu, ImmutableString("modf(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000150u, ImmutableString("isnan(00B").mangledNameHash());
    ASSERT_EQ(0x00000151u, ImmutableString("isnan(10B").mangledNameHash());
    ASSERT_EQ(0x00000152u, ImmutableString("isnan(20B").mangledNameHash());
    ASSERT_EQ(0x00000153u, ImmutableString("isnan(30B").mangledNameHash());
    ASSERT_EQ(0x00000154u, ImmutableString("isnan(00C").mangledNameHash());
    ASSERT_EQ(0x00000155u, ImmutableString("isnan(10C").mangledNameHash());
    ASSERT_EQ(0x00000156u, ImmutableString("isnan(20C").mangledNameHash());
    ASSERT_EQ(0x00000157u, ImmutableString("isnan(30C").mangledNameHash());
    ASSERT_EQ(0x00000158u, ImmutableString("isinf(00B").mangledNameHash());
    ASSERT_EQ(0x00000159u, ImmutableString("isinf(10B").mangledNameHash());
    ASSERT_EQ(0x0000015au, ImmutableString("isinf(20B").mangledNameHash());
    ASSERT_EQ(0x0000015bu, ImmutableString("isinf(30B").mangledNameHash());
    ASSERT_EQ(0x0000015cu, ImmutableString("isinf(00C").mangledNameHash());
    ASSERT_EQ(0x0000015du, ImmutableString("isinf(10C").mangledNameHash());
    ASSERT_EQ(0x0000015eu, ImmutableString("isinf(20C").mangledNameHash());
    ASSERT_EQ(0x0000015fu, ImmutableString("isinf(30C").mangledNameHash());
    ASSERT_EQ(0x00000160u, ImmutableString("floatBitsToInt(00B").mangledNameHash());
    ASSERT_EQ(0x00000161u, ImmutableString("floatBitsToInt(10B").mangledNameHash());
    ASSERT_EQ(0x00000162u, ImmutableString("floatBitsToInt(20B").mangledNameHash());
    ASSERT_EQ(0x00000163u, ImmutableString("floatBitsToInt(30B").mangledNameHash());
    ASSERT_EQ(0x00000164u, ImmutableString("floatBitsToUint(00B").mangledNameHash());
    ASSERT_EQ(0x00000165u, ImmutableString("floatBitsToUint(10B").mangledNameHash());
    ASSERT_EQ(0x00000166u, ImmutableString("floatBitsToUint(20B").mangledNameHash());
    ASSERT_EQ(0x00000167u, ImmutableString("floatBitsToUint(30B").mangledNameHash());
    ASSERT_EQ(0x00000168u, ImmutableString("intBitsToFloat(00D").mangledNameHash());
    ASSERT_EQ(0x00000169u, ImmutableString("intBitsToFloat(10D").mangledNameHash());
    ASSERT_EQ(0x0000016au, ImmutableString("intBitsToFloat(20D").mangledNameHash());
    ASSERT_EQ(0x0000016bu, ImmutableString("intBitsToFloat(30D").mangledNameHash());
    ASSERT_EQ(0x0000016cu, ImmutableString("uintBitsToFloat(00E").mangledNameHash());
    ASSERT_EQ(0x0000016du, ImmutableString("uintBitsToFloat(10E").mangledNameHash());
    ASSERT_EQ(0x0000016eu, ImmutableString("uintBitsToFloat(20E").mangledNameHash());
    ASSERT_EQ(0x0000016fu, ImmutableString("uintBitsToFloat(30E").mangledNameHash());
    ASSERT_EQ(0x00000170u, ImmutableString("fma(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000171u, ImmutableString("fma(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000172u, ImmutableString("fma(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000173u, ImmutableString("fma(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000174u, ImmutableString("fma(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x00000175u, ImmutableString("fma(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x00000176u, ImmutableString("fma(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x00000177u, ImmutableString("fma(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x00000178u, ImmutableString("frexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x00000179u, ImmutableString("frexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x0000017au, ImmutableString("frexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x0000017bu, ImmutableString("frexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x0000017cu, ImmutableString("frexp(00C00D").mangledNameHash());
    ASSERT_EQ(0x0000017du, ImmutableString("frexp(10C10D").mangledNameHash());
    ASSERT_EQ(0x0000017eu, ImmutableString("frexp(20C20D").mangledNameHash());
    ASSERT_EQ(0x0000017fu, ImmutableString("frexp(30C30D").mangledNameHash());
    ASSERT_EQ(0x00000180u, ImmutableString("ldexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x00000181u, ImmutableString("ldexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x00000182u, ImmutableString("ldexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x00000183u, ImmutableString("ldexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x00000184u, ImmutableString("ldexp(00C00D").mangledNameHash());
    ASSERT_EQ(0x00000185u, ImmutableString("ldexp(10C10D").mangledNameHash());
    ASSERT_EQ(0x00000186u, ImmutableString("ldexp(20C20D").mangledNameHash());
    ASSERT_EQ(0x00000187u, ImmutableString("ldexp(30C30D").mangledNameHash());
    ASSERT_EQ(0x00000188u, ImmutableString("packSnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000189u, ImmutableString("packHalf2x16(10B").mangledNameHash());
    ASSERT_EQ(0x0000018au, ImmutableString("unpackSnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000018bu, ImmutableString("unpackHalf2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000018cu, ImmutableString("packUnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x0000018du, ImmutableString("unpackUnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000018eu, ImmutableString("packUnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x0000018fu, ImmutableString("packSnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x00000190u, ImmutableString("unpackUnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x00000191u, ImmutableString("unpackSnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x00000192u, ImmutableString("packDouble2x32(10E").mangledNameHash());
    ASSERT_EQ(0x00000193u, ImmutableString("unpackDouble2x32(00C").mangledNameHash());
    ASSERT_EQ(0x00000194u, ImmutableString("length(00B").mangledNameHash());
    ASSERT_EQ(0x00000195u, ImmutableString("length(10B").mangledNameHash());
    ASSERT_EQ(0x00000196u, ImmutableString("length(20B").mangledNameHash());
    ASSERT_EQ(0x00000197u, ImmutableString("length(30B").mangledNameHash());
    ASSERT_EQ(0x00000198u, ImmutableString("length(00C").mangledNameHash());
    ASSERT_EQ(0x00000199u, ImmutableString("length(10C").mangledNameHash());
    ASSERT_EQ(0x0000019au, ImmutableString("length(20C").mangledNameHash());
    ASSERT_EQ(0x0000019bu, ImmutableString("length(30C").mangledNameHash());
    ASSERT_EQ(0x0000019cu, ImmutableString("distance(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000019du, ImmutableString("distance(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000019eu, ImmutableString("distance(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000019fu, ImmutableString("distance(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001a0u, ImmutableString("distance(00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a1u, ImmutableString("distance(10C10C").mangledNameHash());
    ASSERT_EQ(0x000001a2u, ImmutableString("distance(20C20C").mangledNameHash());
    ASSERT_EQ(0x000001a3u, ImmutableString("distance(30C30C").mangledNameHash());
    ASSERT_EQ(0x000001a4u, ImmutableString("dot(00B00B").mangledNameHash());
    ASSERT_EQ(0x000001a5u, ImmutableString("dot(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001a6u, ImmutableString("dot(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001a7u, ImmutableString("dot(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001a8u, ImmutableString("dot(00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a9u, ImmutableString("dot(10C10C").mangledNameHash());
    ASSERT_EQ(0x000001aau, ImmutableString("dot(20C20C").mangledNameHash());
    ASSERT_EQ(0x000001abu, ImmutableString("dot(30C30C").mangledNameHash());
    ASSERT_EQ(0x000001acu, ImmutableString("cross(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001adu, ImmutableString("cross(20C20C").mangledNameHash());
    ASSERT_EQ(0x000001aeu, ImmutableString("normalize(00B").mangledNameHash());
    ASSERT_EQ(0x000001afu, ImmutableString("normalize(10B").mangledNameHash());
    ASSERT_EQ(0x000001b0u, ImmutableString("normalize(20B").mangledNameHash());
    ASSERT_EQ(0x000001b1u, ImmutableString("normalize(30B").mangledNameHash());
    ASSERT_EQ(0x000001b2u, ImmutableString("normalize(00C").mangledNameHash());
    ASSERT_EQ(0x000001b3u, ImmutableString("normalize(10C").mangledNameHash());
    ASSERT_EQ(0x000001b4u, ImmutableString("normalize(20C").mangledNameHash());
    ASSERT_EQ(0x000001b5u, ImmutableString("normalize(30C").mangledNameHash());
    ASSERT_EQ(0x000001b6u, ImmutableString("faceforward(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000001b7u, ImmutableString("faceforward(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001b8u, ImmutableString("faceforward(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001b9u, ImmutableString("faceforward(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000001bau, ImmutableString("faceforward(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001bbu, ImmutableString("faceforward(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x000001bcu, ImmutableString("faceforward(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x000001bdu, ImmutableString("faceforward(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x000001beu, ImmutableString("reflect(00B00B").mangledNameHash());
    ASSERT_EQ(0x000001bfu, ImmutableString("reflect(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001c0u, ImmutableString("reflect(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001c1u, ImmutableString("reflect(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001c2u, ImmutableString("reflect(00C00C").mangledNameHash());
    ASSERT_EQ(0x000001c3u, ImmutableString("reflect(10C10C").mangledNameHash());
    ASSERT_EQ(0x000001c4u, ImmutableString("reflect(20C20C").mangledNameHash());
    ASSERT_EQ(0x000001c5u, ImmutableString("reflect(30C30C").mangledNameHash());
    ASSERT_EQ(0x000001c6u, ImmutableString("refract(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000001c7u, ImmutableString("refract(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x000001c8u, ImmutableString("refract(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x000001c9u, ImmutableString("refract(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x000001cau, ImmutableString("refract(00C00C00B").mangledNameHash());
    ASSERT_EQ(0x000001cbu, ImmutableString("refract(10C10C00B").mangledNameHash());
    ASSERT_EQ(0x000001ccu, ImmutableString("refract(20C20C00B").mangledNameHash());
    ASSERT_EQ(0x000001cdu, ImmutableString("refract(30C30C00B").mangledNameHash());
    ASSERT_EQ(0x000001ceu, ImmutableString("ftransform(").mangledNameHash());
    ASSERT_EQ(0x000001cfu, ImmutableString("matrixCompMult(50B50B").mangledNameHash());
    ASSERT_EQ(0x000001d0u, ImmutableString("matrixCompMult(A0BA0B").mangledNameHash());
    ASSERT_EQ(0x000001d1u, ImmutableString("matrixCompMult(F0BF0B").mangledNameHash());
    ASSERT_EQ(0x000001d2u, ImmutableString("matrixCompMult(90B90B").mangledNameHash());
    ASSERT_EQ(0x000001d3u, ImmutableString("matrixCompMult(60B60B").mangledNameHash());
    ASSERT_EQ(0x000001d4u, ImmutableString("matrixCompMult(D0BD0B").mangledNameHash());
    ASSERT_EQ(0x000001d5u, ImmutableString("matrixCompMult(70B70B").mangledNameHash());
    ASSERT_EQ(0x000001d6u, ImmutableString("matrixCompMult(E0BE0B").mangledNameHash());
    ASSERT_EQ(0x000001d7u, ImmutableString("matrixCompMult(B0BB0B").mangledNameHash());
    ASSERT_EQ(0x000001d8u, ImmutableString("outerProduct(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001d9u, ImmutableString("outerProduct(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001dau, ImmutableString("outerProduct(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001dbu, ImmutableString("outerProduct(20B10B").mangledNameHash());
    ASSERT_EQ(0x000001dcu, ImmutableString("outerProduct(10B20B").mangledNameHash());
    ASSERT_EQ(0x000001ddu, ImmutableString("outerProduct(30B10B").mangledNameHash());
    ASSERT_EQ(0x000001deu, ImmutableString("outerProduct(10B30B").mangledNameHash());
    ASSERT_EQ(0x000001dfu, ImmutableString("outerProduct(30B20B").mangledNameHash());
    ASSERT_EQ(0x000001e0u, ImmutableString("outerProduct(20B30B").mangledNameHash());
    ASSERT_EQ(0x000001e1u, ImmutableString("transpose(50B").mangledNameHash());
    ASSERT_EQ(0x000001e2u, ImmutableString("transpose(A0B").mangledNameHash());
    ASSERT_EQ(0x000001e3u, ImmutableString("transpose(F0B").mangledNameHash());
    ASSERT_EQ(0x000001e4u, ImmutableString("transpose(60B").mangledNameHash());
    ASSERT_EQ(0x000001e5u, ImmutableString("transpose(90B").mangledNameHash());
    ASSERT_EQ(0x000001e6u, ImmutableString("transpose(70B").mangledNameHash());
    ASSERT_EQ(0x000001e7u, ImmutableString("transpose(D0B").mangledNameHash());
    ASSERT_EQ(0x000001e8u, ImmutableString("transpose(B0B").mangledNameHash());
    ASSERT_EQ(0x000001e9u, ImmutableString("transpose(E0B").mangledNameHash());
    ASSERT_EQ(0x000001eau, ImmutableString("determinant(50B").mangledNameHash());
    ASSERT_EQ(0x000001ebu, ImmutableString("determinant(A0B").mangledNameHash());
    ASSERT_EQ(0x000001ecu, ImmutableString("determinant(F0B").mangledNameHash());
    ASSERT_EQ(0x000001edu, ImmutableString("inverse(50B").mangledNameHash());
    ASSERT_EQ(0x000001eeu, ImmutableString("inverse(A0B").mangledNameHash());
    ASSERT_EQ(0x000001efu, ImmutableString("inverse(F0B").mangledNameHash());
    ASSERT_EQ(0x000001f0u, ImmutableString("lessThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001f1u, ImmutableString("lessThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001f2u, ImmutableString("lessThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001f3u, ImmutableString("lessThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000001f4u, ImmutableString("lessThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x000001f5u, ImmutableString("lessThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x000001f6u, ImmutableString("lessThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000001f7u, ImmutableString("lessThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001f8u, ImmutableString("lessThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x000001f9u, ImmutableString("lessThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001fau, ImmutableString("lessThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001fbu, ImmutableString("lessThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001fcu, ImmutableString("lessThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x000001fdu, ImmutableString("lessThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x000001feu, ImmutableString("lessThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x000001ffu, ImmutableString("lessThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000200u, ImmutableString("lessThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000201u, ImmutableString("lessThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000202u, ImmutableString("greaterThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000203u, ImmutableString("greaterThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000204u, ImmutableString("greaterThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000205u, ImmutableString("greaterThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000206u, ImmutableString("greaterThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000207u, ImmutableString("greaterThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000208u, ImmutableString("greaterThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000209u, ImmutableString("greaterThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000020au, ImmutableString("greaterThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000020bu, ImmutableString("greaterThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000020cu, ImmutableString("greaterThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000020du, ImmutableString("greaterThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000020eu, ImmutableString("greaterThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000020fu, ImmutableString("greaterThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000210u, ImmutableString("greaterThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000211u, ImmutableString("greaterThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000212u, ImmutableString("greaterThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000213u, ImmutableString("greaterThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000214u, ImmutableString("equal(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000215u, ImmutableString("equal(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000216u, ImmutableString("equal(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000217u, ImmutableString("equal(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000218u, ImmutableString("equal(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000219u, ImmutableString("equal(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000021au, ImmutableString("equal(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000021bu, ImmutableString("equal(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000021cu, ImmutableString("equal(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000021du, ImmutableString("equal(10F10F").mangledNameHash());
    ASSERT_EQ(0x0000021eu, ImmutableString("equal(20F20F").mangledNameHash());
    ASSERT_EQ(0x0000021fu, ImmutableString("equal(30F30F").mangledNameHash());
    ASSERT_EQ(0x00000220u, ImmutableString("notEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000221u, ImmutableString("notEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000222u, ImmutableString("notEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000223u, ImmutableString("notEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000224u, ImmutableString("notEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000225u, ImmutableString("notEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000226u, ImmutableString("notEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000227u, ImmutableString("notEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000228u, ImmutableString("notEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000229u, ImmutableString("notEqual(10F10F").mangledNameHash());
    ASSERT_EQ(0x0000022au, ImmutableString("notEqual(20F20F").mangledNameHash());
    ASSERT_EQ(0x0000022bu, ImmutableString("notEqual(30F30F").mangledNameHash());
    ASSERT_EQ(0x0000022cu, ImmutableString("any(10F").mangledNameHash());
    ASSERT_EQ(0x0000022du, ImmutableString("any(20F").mangledNameHash());
    ASSERT_EQ(0x0000022eu, ImmutableString("any(30F").mangledNameHash());
    ASSERT_EQ(0x0000022fu, ImmutableString("all(10F").mangledNameHash());
    ASSERT_EQ(0x00000230u, ImmutableString("all(20F").mangledNameHash());
    ASSERT_EQ(0x00000231u, ImmutableString("all(30F").mangledNameHash());
    ASSERT_EQ(0x00000232u, ImmutableString("not(10F").mangledNameHash());
    ASSERT_EQ(0x00000233u, ImmutableString("not(20F").mangledNameHash());
    ASSERT_EQ(0x00000234u, ImmutableString("not(30F").mangledNameHash());
    ASSERT_EQ(0x00000235u, ImmutableString("bitfieldExtract(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000236u, ImmutableString("bitfieldExtract(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000237u, ImmutableString("bitfieldExtract(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000238u, ImmutableString("bitfieldExtract(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000239u, ImmutableString("bitfieldExtract(00E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023au, ImmutableString("bitfieldExtract(10E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023bu, ImmutableString("bitfieldExtract(20E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023cu, ImmutableString("bitfieldExtract(30E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023du, ImmutableString("bitfieldInsert(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023eu, ImmutableString("bitfieldInsert(10D10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023fu, ImmutableString("bitfieldInsert(20D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000240u, ImmutableString("bitfieldInsert(30D30D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000241u, ImmutableString("bitfieldInsert(00E00E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000242u, ImmutableString("bitfieldInsert(10E10E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000243u, ImmutableString("bitfieldInsert(20E20E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000244u, ImmutableString("bitfieldInsert(30E30E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000245u, ImmutableString("bitfieldReverse(00D").mangledNameHash());
    ASSERT_EQ(0x00000246u, ImmutableString("bitfieldReverse(10D").mangledNameHash());
    ASSERT_EQ(0x00000247u, ImmutableString("bitfieldReverse(20D").mangledNameHash());
    ASSERT_EQ(0x00000248u, ImmutableString("bitfieldReverse(30D").mangledNameHash());
    ASSERT_EQ(0x00000249u, ImmutableString("bitfieldReverse(00E").mangledNameHash());
    ASSERT_EQ(0x0000024au, ImmutableString("bitfieldReverse(10E").mangledNameHash());
    ASSERT_EQ(0x0000024bu, ImmutableString("bitfieldReverse(20E").mangledNameHash());
    ASSERT_EQ(0x0000024cu, ImmutableString("bitfieldReverse(30E").mangledNameHash());
    ASSERT_EQ(0x0000024du, ImmutableString("bitCount(00D").mangledNameHash());
    ASSERT_EQ(0x0000024eu, ImmutableString("bitCount(10D").mangledNameHash());
    ASSERT_EQ(0x0000024fu, ImmutableString("bitCount(20D").mangledNameHash());
    ASSERT_EQ(0x00000250u, ImmutableString("bitCount(30D").mangledNameHash());
    ASSERT_EQ(0x00000251u, ImmutableString("bitCount(00E").mangledNameHash());
    ASSERT_EQ(0x00000252u, ImmutableString("bitCount(10E").mangledNameHash());
    ASSERT_EQ(0x00000253u, ImmutableString("bitCount(20E").mangledNameHash());
    ASSERT_EQ(0x00000254u, ImmutableString("bitCount(30E").mangledNameHash());
    ASSERT_EQ(0x00000255u, ImmutableString("findLSB(00D").mangledNameHash());
    ASSERT_EQ(0x00000256u, ImmutableString("findLSB(10D").mangledNameHash());
    ASSERT_EQ(0x00000257u, ImmutableString("findLSB(20D").mangledNameHash());
    ASSERT_EQ(0x00000258u, ImmutableString("findLSB(30D").mangledNameHash());
    ASSERT_EQ(0x00000259u, ImmutableString("findLSB(00E").mangledNameHash());
    ASSERT_EQ(0x0000025au, ImmutableString("findLSB(10E").mangledNameHash());
    ASSERT_EQ(0x0000025bu, ImmutableString("findLSB(20E").mangledNameHash());
    ASSERT_EQ(0x0000025cu, ImmutableString("findLSB(30E").mangledNameHash());
    ASSERT_EQ(0x0000025du, ImmutableString("findMSB(00D").mangledNameHash());
    ASSERT_EQ(0x0000025eu, ImmutableString("findMSB(10D").mangledNameHash());
    ASSERT_EQ(0x0000025fu, ImmutableString("findMSB(20D").mangledNameHash());
    ASSERT_EQ(0x00000260u, ImmutableString("findMSB(30D").mangledNameHash());
    ASSERT_EQ(0x00000261u, ImmutableString("findMSB(00E").mangledNameHash());
    ASSERT_EQ(0x00000262u, ImmutableString("findMSB(10E").mangledNameHash());
    ASSERT_EQ(0x00000263u, ImmutableString("findMSB(20E").mangledNameHash());
    ASSERT_EQ(0x00000264u, ImmutableString("findMSB(30E").mangledNameHash());
    ASSERT_EQ(0x00000265u, ImmutableString("uaddCarry(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000266u, ImmutableString("uaddCarry(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000267u, ImmutableString("uaddCarry(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x00000268u, ImmutableString("uaddCarry(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000269u, ImmutableString("usubBorrow(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000026au, ImmutableString("usubBorrow(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x0000026bu, ImmutableString("usubBorrow(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000026cu, ImmutableString("usubBorrow(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x0000026du, ImmutableString("umulExtended(00E00E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000026eu, ImmutableString("umulExtended(10E10E10E10E").mangledNameHash());
    ASSERT_EQ(0x0000026fu, ImmutableString("umulExtended(20E20E20E20E").mangledNameHash());
    ASSERT_EQ(0x00000270u, ImmutableString("umulExtended(30E30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000271u, ImmutableString("imulExtended(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000272u, ImmutableString("imulExtended(10D10D10D10D").mangledNameHash());
    ASSERT_EQ(0x00000273u, ImmutableString("imulExtended(20D20D20D20D").mangledNameHash());
    ASSERT_EQ(0x00000274u, ImmutableString("imulExtended(30D30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000275u, ImmutableString("texture2D(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000276u, ImmutableString("texture2DProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000277u, ImmutableString("texture2DProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000278u, ImmutableString("textureCube(00K20B").mangledNameHash());
    ASSERT_EQ(0x00000279u, ImmutableString("texture1D(00g00B").mangledNameHash());
    ASSERT_EQ(0x0000027au, ImmutableString("texture1DProj(00g10B").mangledNameHash());
    ASSERT_EQ(0x0000027bu, ImmutableString("texture1DProj(00g30B").mangledNameHash());
    ASSERT_EQ(0x0000027cu, ImmutableString("texture3D(00J20B").mangledNameHash());
    ASSERT_EQ(0x0000027du, ImmutableString("texture3DProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x0000027eu, ImmutableString("shadow1D(00m20B").mangledNameHash());
    ASSERT_EQ(0x0000027fu, ImmutableString("shadow1DProj(00m30B").mangledNameHash());
    ASSERT_EQ(0x00000280u, ImmutableString("shadow2D(00d20B").mangledNameHash());
    ASSERT_EQ(0x00000281u, ImmutableString("shadow2DProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x00000282u, ImmutableString("shadow2DEXT(00d20B").mangledNameHash());
    ASSERT_EQ(0x00000283u, ImmutableString("shadow2DProjEXT(00d30B").mangledNameHash());
    ASSERT_EQ(0x00000284u, ImmutableString("texture2D(00M10B").mangledNameHash());
    ASSERT_EQ(0x00000285u, ImmutableString("texture2DProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x00000286u, ImmutableString("texture2DProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x00000287u, ImmutableString("texture2DRect(00O10B").mangledNameHash());
    ASSERT_EQ(0x00000288u, ImmutableString("texture2DRectProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x00000289u, ImmutableString("texture2DRectProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x0000028au, ImmutableString("texture2DGradEXT(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000028bu, ImmutableString("texture2DProjGradEXT(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000028cu, ImmutableString("texture2DProjGradEXT(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000028du, ImmutableString("textureCubeGradEXT(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000028eu, ImmutableString("textureVideoWEBGL(00y10B").mangledNameHash());
    ASSERT_EQ(0x0000028fu, ImmutableString("texture2D(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000290u, ImmutableString("texture2DProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000291u, ImmutableString("texture2DProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000292u, ImmutableString("textureCube(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x00000293u, ImmutableString("texture3D(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000294u, ImmutableString("texture3DProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x00000295u, ImmutableString("texture1D(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x00000296u, ImmutableString("texture1DProj(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x00000297u, ImmutableString("texture1DProj(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x00000298u, ImmutableString("shadow1D(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x00000299u, ImmutableString("shadow1DProj(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x0000029au, ImmutableString("shadow2D(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029bu, ImmutableString("shadow2DProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x0000029cu, ImmutableString("texture2DLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000029du, ImmutableString("texture2DProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029eu, ImmutableString("texture2DProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x0000029fu, ImmutableString("textureCubeLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a0u, ImmutableString("texture1DLod(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x000002a1u, ImmutableString("texture1DProjLod(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x000002a2u, ImmutableString("texture1DProjLod(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a3u, ImmutableString("shadow1DLod(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a4u, ImmutableString("shadow1DProjLod(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a5u, ImmutableString("shadow2DLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a6u, ImmutableString("shadow2DProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a7u, ImmutableString("texture3DLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a8u, ImmutableString("texture3DProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a9u, ImmutableString("texture2DLodEXT(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000002aau, ImmutableString("texture2DProjLodEXT(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000002abu, ImmutableString("texture2DProjLodEXT(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000002acu, ImmutableString("textureCubeLodEXT(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000002adu, ImmutableString("texture(00I10B").mangledNameHash());
    ASSERT_EQ(0x000002aeu, ImmutableString("texture(00R10B").mangledNameHash());
    ASSERT_EQ(0x000002afu, ImmutableString("texture(00X10B").mangledNameHash());
    ASSERT_EQ(0x000002b0u, ImmutableString("texture(00J20B").mangledNameHash());
    ASSERT_EQ(0x000002b1u, ImmutableString("texture(00S20B").mangledNameHash());
    ASSERT_EQ(0x000002b2u, ImmutableString("texture(00Y20B").mangledNameHash());
    ASSERT_EQ(0x000002b3u, ImmutableString("texture(00K20B").mangledNameHash());
    ASSERT_EQ(0x000002b4u, ImmutableString("texture(00T20B").mangledNameHash());
    ASSERT_EQ(0x000002b5u, ImmutableString("texture(00Z20B").mangledNameHash());
    ASSERT_EQ(0x000002b6u, ImmutableString("texture(00L20B").mangledNameHash());
    ASSERT_EQ(0x000002b7u, ImmutableString("texture(00U20B").mangledNameHash());
    ASSERT_EQ(0x000002b8u, ImmutableString("texture(00a20B").mangledNameHash());
    ASSERT_EQ(0x000002b9u, ImmutableString("texture(00d20B").mangledNameHash());
    ASSERT_EQ(0x000002bau, ImmutableString("texture(00e30B").mangledNameHash());
    ASSERT_EQ(0x000002bbu, ImmutableString("texture(00f30B").mangledNameHash());
    ASSERT_EQ(0x000002bcu, ImmutableString("texture(00g00B").mangledNameHash());
    ASSERT_EQ(0x000002bdu, ImmutableString("texture(00o00B").mangledNameHash());
    ASSERT_EQ(0x000002beu, ImmutableString("texture(00t00B").mangledNameHash());
    ASSERT_EQ(0x000002bfu, ImmutableString("texture(00m20B").mangledNameHash());
    ASSERT_EQ(0x000002c0u, ImmutableString("texture(00h20B").mangledNameHash());
    ASSERT_EQ(0x000002c1u, ImmutableString("texture(00p20B").mangledNameHash());
    ASSERT_EQ(0x000002c2u, ImmutableString("texture(00u20B").mangledNameHash());
    ASSERT_EQ(0x000002c3u, ImmutableString("texture(00i20B").mangledNameHash());
    ASSERT_EQ(0x000002c4u, ImmutableString("texture(00O10B").mangledNameHash());
    ASSERT_EQ(0x000002c5u, ImmutableString("texture(00q10B").mangledNameHash());
    ASSERT_EQ(0x000002c6u, ImmutableString("texture(00v10B").mangledNameHash());
    ASSERT_EQ(0x000002c7u, ImmutableString("texture(00n20B").mangledNameHash());
    ASSERT_EQ(0x000002c8u, ImmutableString("texture(00k30B").mangledNameHash());
    ASSERT_EQ(0x000002c9u, ImmutableString("texture(00s30B").mangledNameHash());
    ASSERT_EQ(0x000002cau, ImmutableString("texture(00x30B").mangledNameHash());
    ASSERT_EQ(0x000002cbu, ImmutableString("texture(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x000002ccu, ImmutableString("texture(00M10B").mangledNameHash());
    ASSERT_EQ(0x000002cdu, ImmutableString("texture(00N10B").mangledNameHash());
    ASSERT_EQ(0x000002ceu, ImmutableString("texture(00y10B").mangledNameHash());
    ASSERT_EQ(0x000002cfu, ImmutableString("textureProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x000002d0u, ImmutableString("textureProj(00R20B").mangledNameHash());
    ASSERT_EQ(0x000002d1u, ImmutableString("textureProj(00X20B").mangledNameHash());
    ASSERT_EQ(0x000002d2u, ImmutableString("textureProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x000002d3u, ImmutableString("textureProj(00R30B").mangledNameHash());
    ASSERT_EQ(0x000002d4u, ImmutableString("textureProj(00X30B").mangledNameHash());
    ASSERT_EQ(0x000002d5u, ImmutableString("textureProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x000002d6u, ImmutableString("textureProj(00S30B").mangledNameHash());
    ASSERT_EQ(0x000002d7u, ImmutableString("textureProj(00Y30B").mangledNameHash());
    ASSERT_EQ(0x000002d8u, ImmutableString("textureProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x000002d9u, ImmutableString("textureProj(00g10B").mangledNameHash());
    ASSERT_EQ(0x000002dau, ImmutableString("textureProj(00o10B").mangledNameHash());
    ASSERT_EQ(0x000002dbu, ImmutableString("textureProj(00t10B").mangledNameHash());
    ASSERT_EQ(0x000002dcu, ImmutableString("textureProj(00g30B").mangledNameHash());
    ASSERT_EQ(0x000002ddu, ImmutableString("textureProj(00o30B").mangledNameHash());
    ASSERT_EQ(0x000002deu, ImmutableString("textureProj(00t30B").mangledNameHash());
    ASSERT_EQ(0x000002dfu, ImmutableString("textureProj(00m30B").mangledNameHash());
    ASSERT_EQ(0x000002e0u, ImmutableString("textureProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x000002e1u, ImmutableString("textureProj(00q20B").mangledNameHash());
    ASSERT_EQ(0x000002e2u, ImmutableString("textureProj(00v20B").mangledNameHash());
    ASSERT_EQ(0x000002e3u, ImmutableString("textureProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x000002e4u, ImmutableString("textureProj(00q30B").mangledNameHash());
    ASSERT_EQ(0x000002e5u, ImmutableString("textureProj(00v30B").mangledNameHash());
    ASSERT_EQ(0x000002e6u, ImmutableString("textureProj(00n30B").mangledNameHash());
    ASSERT_EQ(0x000002e7u, ImmutableString("textureProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x000002e8u, ImmutableString("textureProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x000002e9u, ImmutableString("textureProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x000002eau, ImmutableString("textureProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x000002ebu, ImmutableString("textureLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000002ecu, ImmutableString("textureLod(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x000002edu, ImmutableString("textureLod(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000002eeu, ImmutableString("textureLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000002efu, ImmutableString("textureLod(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f0u, ImmutableString("textureLod(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f1u, ImmutableString("textureLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f2u, ImmutableString("textureLod(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f3u, ImmutableString("textureLod(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f4u, ImmutableString("textureLod(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f5u, ImmutableString("textureLod(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f6u, ImmutableString("textureLod(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f7u, ImmutableString("textureLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x000002f8u, ImmutableString("textureLod(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x000002f9u, ImmutableString("textureLod(00o00B00B").mangledNameHash());
    ASSERT_EQ(0x000002fau, ImmutableString("textureLod(00t00B00B").mangledNameHash());
    ASSERT_EQ(0x000002fbu, ImmutableString("textureLod(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x000002fcu, ImmutableString("textureLod(00h10B00B").mangledNameHash());
    ASSERT_EQ(0x000002fdu, ImmutableString("textureLod(00p10B00B").mangledNameHash());
    ASSERT_EQ(0x000002feu, ImmutableString("textureLod(00u10B00B").mangledNameHash());
    ASSERT_EQ(0x000002ffu, ImmutableString("textureLod(00i20B00B").mangledNameHash());
    ASSERT_EQ(0x00000300u, ImmutableString("textureLod(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x00000301u, ImmutableString("textureLod(00s30B00B").mangledNameHash());
    ASSERT_EQ(0x00000302u, ImmutableString("textureLod(00x30B00B").mangledNameHash());
    ASSERT_EQ(0x00000303u, ImmutableString("textureSize(00I00D").mangledNameHash());
    ASSERT_EQ(0x00000304u, ImmutableString("textureSize(00R00D").mangledNameHash());
    ASSERT_EQ(0x00000305u, ImmutableString("textureSize(00X00D").mangledNameHash());
    ASSERT_EQ(0x00000306u, ImmutableString("textureSize(00J00D").mangledNameHash());
    ASSERT_EQ(0x00000307u, ImmutableString("textureSize(00S00D").mangledNameHash());
    ASSERT_EQ(0x00000308u, ImmutableString("textureSize(00Y00D").mangledNameHash());
    ASSERT_EQ(0x00000309u, ImmutableString("textureSize(00K00D").mangledNameHash());
    ASSERT_EQ(0x0000030au, ImmutableString("textureSize(00T00D").mangledNameHash());
    ASSERT_EQ(0x0000030bu, ImmutableString("textureSize(00Z00D").mangledNameHash());
    ASSERT_EQ(0x0000030cu, ImmutableString("textureSize(00L00D").mangledNameHash());
    ASSERT_EQ(0x0000030du, ImmutableString("textureSize(00U00D").mangledNameHash());
    ASSERT_EQ(0x0000030eu, ImmutableString("textureSize(00a00D").mangledNameHash());
    ASSERT_EQ(0x0000030fu, ImmutableString("textureSize(00d00D").mangledNameHash());
    ASSERT_EQ(0x00000310u, ImmutableString("textureSize(00e00D").mangledNameHash());
    ASSERT_EQ(0x00000311u, ImmutableString("textureSize(00f00D").mangledNameHash());
    ASSERT_EQ(0x00000312u, ImmutableString("textureSize(00g00D").mangledNameHash());
    ASSERT_EQ(0x00000313u, ImmutableString("textureSize(00o00D").mangledNameHash());
    ASSERT_EQ(0x00000314u, ImmutableString("textureSize(00t00D").mangledNameHash());
    ASSERT_EQ(0x00000315u, ImmutableString("textureSize(00m00D").mangledNameHash());
    ASSERT_EQ(0x00000316u, ImmutableString("textureSize(00k00D").mangledNameHash());
    ASSERT_EQ(0x00000317u, ImmutableString("textureSize(00s00D").mangledNameHash());
    ASSERT_EQ(0x00000318u, ImmutableString("textureSize(00x00D").mangledNameHash());
    ASSERT_EQ(0x00000319u, ImmutableString("textureSize(00l00D").mangledNameHash());
    ASSERT_EQ(0x0000031au, ImmutableString("textureSize(00O").mangledNameHash());
    ASSERT_EQ(0x0000031bu, ImmutableString("textureSize(00q").mangledNameHash());
    ASSERT_EQ(0x0000031cu, ImmutableString("textureSize(00v").mangledNameHash());
    ASSERT_EQ(0x0000031du, ImmutableString("textureSize(00n").mangledNameHash());
    ASSERT_EQ(0x0000031eu, ImmutableString("textureSize(00h00D").mangledNameHash());
    ASSERT_EQ(0x0000031fu, ImmutableString("textureSize(00p00D").mangledNameHash());
    ASSERT_EQ(0x00000320u, ImmutableString("textureSize(00u00D").mangledNameHash());
    ASSERT_EQ(0x00000321u, ImmutableString("textureSize(00i00D").mangledNameHash());
    ASSERT_EQ(0x00000322u, ImmutableString("textureSize(00j").mangledNameHash());
    ASSERT_EQ(0x00000323u, ImmutableString("textureSize(00r").mangledNameHash());
    ASSERT_EQ(0x00000324u, ImmutableString("textureSize(00w").mangledNameHash());
    ASSERT_EQ(0x00000325u, ImmutableString("textureSize(00P").mangledNameHash());
    ASSERT_EQ(0x00000326u, ImmutableString("textureSize(00V").mangledNameHash());
    ASSERT_EQ(0x00000327u, ImmutableString("textureSize(00b").mangledNameHash());
    ASSERT_EQ(0x00000328u, ImmutableString("textureSize(00Q").mangledNameHash());
    ASSERT_EQ(0x00000329u, ImmutableString("textureSize(00W").mangledNameHash());
    ASSERT_EQ(0x0000032au, ImmutableString("textureSize(00c").mangledNameHash());
    ASSERT_EQ(0x0000032bu, ImmutableString("textureSize(00M00D").mangledNameHash());
    ASSERT_EQ(0x0000032cu, ImmutableString("textureSize(00N00D").mangledNameHash());
    ASSERT_EQ(0x0000032du, ImmutableString("textureProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x0000032eu, ImmutableString("textureProjLod(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x0000032fu, ImmutableString("textureProjLod(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x00000330u, ImmutableString("textureProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000331u, ImmutableString("textureProjLod(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000332u, ImmutableString("textureProjLod(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x00000333u, ImmutableString("textureProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x00000334u, ImmutableString("textureProjLod(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x00000335u, ImmutableString("textureProjLod(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x00000336u, ImmutableString("textureProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x00000337u, ImmutableString("textureProjLod(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x00000338u, ImmutableString("textureProjLod(00o10B00B").mangledNameHash());
    ASSERT_EQ(0x00000339u, ImmutableString("textureProjLod(00t10B00B").mangledNameHash());
    ASSERT_EQ(0x0000033au, ImmutableString("textureProjLod(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x0000033bu, ImmutableString("textureProjLod(00o30B00B").mangledNameHash());
    ASSERT_EQ(0x0000033cu, ImmutableString("textureProjLod(00t30B00B").mangledNameHash());
    ASSERT_EQ(0x0000033du, ImmutableString("textureProjLod(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x0000033eu, ImmutableString("texelFetch(00I10D00D").mangledNameHash());
    ASSERT_EQ(0x0000033fu, ImmutableString("texelFetch(00R10D00D").mangledNameHash());
    ASSERT_EQ(0x00000340u, ImmutableString("texelFetch(00X10D00D").mangledNameHash());
    ASSERT_EQ(0x00000341u, ImmutableString("texelFetch(00J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000342u, ImmutableString("texelFetch(00S20D00D").mangledNameHash());
    ASSERT_EQ(0x00000343u, ImmutableString("texelFetch(00Y20D00D").mangledNameHash());
    ASSERT_EQ(0x00000344u, ImmutableString("texelFetch(00L20D00D").mangledNameHash());
    ASSERT_EQ(0x00000345u, ImmutableString("texelFetch(00U20D00D").mangledNameHash());
    ASSERT_EQ(0x00000346u, ImmutableString("texelFetch(00a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000347u, ImmutableString("texelFetch(00g00D00D").mangledNameHash());
    ASSERT_EQ(0x00000348u, ImmutableString("texelFetch(00o00D00D").mangledNameHash());
    ASSERT_EQ(0x00000349u, ImmutableString("texelFetch(00t00D00D").mangledNameHash());
    ASSERT_EQ(0x0000034au, ImmutableString("texelFetch(00O10D").mangledNameHash());
    ASSERT_EQ(0x0000034bu, ImmutableString("texelFetch(00q10D").mangledNameHash());
    ASSERT_EQ(0x0000034cu, ImmutableString("texelFetch(00v10D").mangledNameHash());
    ASSERT_EQ(0x0000034du, ImmutableString("texelFetch(00h10D00D").mangledNameHash());
    ASSERT_EQ(0x0000034eu, ImmutableString("texelFetch(00p10D00D").mangledNameHash());
    ASSERT_EQ(0x0000034fu, ImmutableString("texelFetch(00u10D00D").mangledNameHash());
    ASSERT_EQ(0x00000350u, ImmutableString("texelFetch(00j00D").mangledNameHash());
    ASSERT_EQ(0x00000351u, ImmutableString("texelFetch(00r00D").mangledNameHash());
    ASSERT_EQ(0x00000352u, ImmutableString("texelFetch(00w00D").mangledNameHash());
    ASSERT_EQ(0x00000353u, ImmutableString("texelFetch(00P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000354u, ImmutableString("texelFetch(00V10D00D").mangledNameHash());
    ASSERT_EQ(0x00000355u, ImmutableString("texelFetch(00b10D00D").mangledNameHash());
    ASSERT_EQ(0x00000356u, ImmutableString("texelFetch(00Q20D00D").mangledNameHash());
    ASSERT_EQ(0x00000357u, ImmutableString("texelFetch(00W20D00D").mangledNameHash());
    ASSERT_EQ(0x00000358u, ImmutableString("texelFetch(00c20D00D").mangledNameHash());
    ASSERT_EQ(0x00000359u, ImmutableString("texelFetch(00M10D00D").mangledNameHash());
    ASSERT_EQ(0x0000035au, ImmutableString("texelFetch(00N10D00D").mangledNameHash());
    ASSERT_EQ(0x0000035bu, ImmutableString("textureGrad(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000035cu, ImmutableString("textureGrad(00R10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000035du, ImmutableString("textureGrad(00X10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000035eu, ImmutableString("textureGrad(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000035fu, ImmutableString("textureGrad(00S20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000360u, ImmutableString("textureGrad(00Y20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000361u, ImmutableString("textureGrad(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000362u, ImmutableString("textureGrad(00T20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000363u, ImmutableString("textureGrad(00Z20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000364u, ImmutableString("textureGrad(00I00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000365u, ImmutableString("textureGrad(00R00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000366u, ImmutableString("textureGrad(00X00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000367u, ImmutableString("textureGrad(00O10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000368u, ImmutableString("textureGrad(00q10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000369u, ImmutableString("textureGrad(00v10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000036au, ImmutableString("textureGrad(00n20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000036bu, ImmutableString("textureGrad(00d20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000036cu, ImmutableString("textureGrad(00e30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000036du, ImmutableString("textureGrad(00L20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000036eu, ImmutableString("textureGrad(00U20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000036fu, ImmutableString("textureGrad(00a20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000370u, ImmutableString("textureGrad(00f30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000371u, ImmutableString("textureGrad(00m20B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000372u, ImmutableString("textureGrad(00h10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000373u, ImmutableString("textureGrad(00p10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000374u, ImmutableString("textureGrad(00u10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000375u, ImmutableString("textureGrad(00i20B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000376u, ImmutableString("textureGrad(00k30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000377u, ImmutableString("textureGrad(00s30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000378u, ImmutableString("textureGrad(00x30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000379u, ImmutableString("textureProjGrad(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000037au, ImmutableString("textureProjGrad(00R20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000037bu, ImmutableString("textureProjGrad(00X20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000037cu, ImmutableString("textureProjGrad(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000037du, ImmutableString("textureProjGrad(00R30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000037eu, ImmutableString("textureProjGrad(00X30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000037fu, ImmutableString("textureProjGrad(00J30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000380u, ImmutableString("textureProjGrad(00S30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000381u, ImmutableString("textureProjGrad(00Y30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000382u, ImmutableString("textureProjGrad(00d30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000383u, ImmutableString("textureProjGrad(00g10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000384u, ImmutableString("textureProjGrad(00o10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000385u, ImmutableString("textureProjGrad(00t10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000386u, ImmutableString("textureProjGrad(00g30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000387u, ImmutableString("textureProjGrad(00o30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000388u, ImmutableString("textureProjGrad(00t30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000389u, ImmutableString("textureProjGrad(00m30B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000038au, ImmutableString("textureProjGrad(00O20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000038bu, ImmutableString("textureProjGrad(00q20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000038cu, ImmutableString("textureProjGrad(00v20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000038du, ImmutableString("textureProjGrad(00O30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000038eu, ImmutableString("textureProjGrad(00q30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000038fu, ImmutableString("textureProjGrad(00v30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000390u, ImmutableString("textureProjGrad(00n30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000391u, ImmutableString("textureQueryLevels(00g").mangledNameHash());
    ASSERT_EQ(0x00000392u, ImmutableString("textureQueryLevels(00o").mangledNameHash());
    ASSERT_EQ(0x00000393u, ImmutableString("textureQueryLevels(00t").mangledNameHash());
    ASSERT_EQ(0x00000394u, ImmutableString("textureQueryLevels(00I").mangledNameHash());
    ASSERT_EQ(0x00000395u, ImmutableString("textureQueryLevels(00R").mangledNameHash());
    ASSERT_EQ(0x00000396u, ImmutableString("textureQueryLevels(00X").mangledNameHash());
    ASSERT_EQ(0x00000397u, ImmutableString("textureQueryLevels(00J").mangledNameHash());
    ASSERT_EQ(0x00000398u, ImmutableString("textureQueryLevels(00S").mangledNameHash());
    ASSERT_EQ(0x00000399u, ImmutableString("textureQueryLevels(00Y").mangledNameHash());
    ASSERT_EQ(0x0000039au, ImmutableString("textureQueryLevels(00K").mangledNameHash());
    ASSERT_EQ(0x0000039bu, ImmutableString("textureQueryLevels(00T").mangledNameHash());
    ASSERT_EQ(0x0000039cu, ImmutableString("textureQueryLevels(00Z").mangledNameHash());
    ASSERT_EQ(0x0000039du, ImmutableString("textureQueryLevels(00h").mangledNameHash());
    ASSERT_EQ(0x0000039eu, ImmutableString("textureQueryLevels(00p").mangledNameHash());
    ASSERT_EQ(0x0000039fu, ImmutableString("textureQueryLevels(00u").mangledNameHash());
    ASSERT_EQ(0x000003a0u, ImmutableString("textureQueryLevels(00L").mangledNameHash());
    ASSERT_EQ(0x000003a1u, ImmutableString("textureQueryLevels(00U").mangledNameHash());
    ASSERT_EQ(0x000003a2u, ImmutableString("textureQueryLevels(00a").mangledNameHash());
    ASSERT_EQ(0x000003a3u, ImmutableString("textureQueryLevels(00k").mangledNameHash());
    ASSERT_EQ(0x000003a4u, ImmutableString("textureQueryLevels(00s").mangledNameHash());
    ASSERT_EQ(0x000003a5u, ImmutableString("textureQueryLevels(00x").mangledNameHash());
    ASSERT_EQ(0x000003a6u, ImmutableString("textureQueryLevels(00m").mangledNameHash());
    ASSERT_EQ(0x000003a7u, ImmutableString("textureQueryLevels(00d").mangledNameHash());
    ASSERT_EQ(0x000003a8u, ImmutableString("textureQueryLevels(00e").mangledNameHash());
    ASSERT_EQ(0x000003a9u, ImmutableString("textureQueryLevels(00i").mangledNameHash());
    ASSERT_EQ(0x000003aau, ImmutableString("textureQueryLevels(00f").mangledNameHash());
    ASSERT_EQ(0x000003abu, ImmutableString("textureQueryLevels(00l").mangledNameHash());
    ASSERT_EQ(0x000003acu, ImmutableString("textureSamples(00P").mangledNameHash());
    ASSERT_EQ(0x000003adu, ImmutableString("textureSamples(00V").mangledNameHash());
    ASSERT_EQ(0x000003aeu, ImmutableString("textureSamples(00b").mangledNameHash());
    ASSERT_EQ(0x000003afu, ImmutableString("textureSamples(00Q").mangledNameHash());
    ASSERT_EQ(0x000003b0u, ImmutableString("textureSamples(00W").mangledNameHash());
    ASSERT_EQ(0x000003b1u, ImmutableString("textureSamples(00c").mangledNameHash());
    ASSERT_EQ(0x000003b2u, ImmutableString("texture(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000003b3u, ImmutableString("texture(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x000003b4u, ImmutableString("texture(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000003b5u, ImmutableString("texture(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000003b6u, ImmutableString("texture(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x000003b7u, ImmutableString("texture(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000003b8u, ImmutableString("texture(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000003b9u, ImmutableString("texture(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000003bau, ImmutableString("texture(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x000003bbu, ImmutableString("texture(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x000003bcu, ImmutableString("texture(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x000003bdu, ImmutableString("texture(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x000003beu, ImmutableString("textureProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000003bfu, ImmutableString("textureProj(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x000003c0u, ImmutableString("textureProj(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000003c1u, ImmutableString("textureProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c2u, ImmutableString("textureProj(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c3u, ImmutableString("textureProj(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c4u, ImmutableString("textureProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c5u, ImmutableString("textureProj(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c6u, ImmutableString("textureProj(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c7u, ImmutableString("texture(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x000003c8u, ImmutableString("texture(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c9u, ImmutableString("textureProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x000003cau, ImmutableString("texture(00g00B00B").mangledNameHash());
    ASSERT_EQ(0x000003cbu, ImmutableString("texture(00o00B00B").mangledNameHash());
    ASSERT_EQ(0x000003ccu, ImmutableString("texture(00t00B00B").mangledNameHash());
    ASSERT_EQ(0x000003cdu, ImmutableString("texture(00m20B00B").mangledNameHash());
    ASSERT_EQ(0x000003ceu, ImmutableString("texture(00h20B00B").mangledNameHash());
    ASSERT_EQ(0x000003cfu, ImmutableString("texture(00p20B00B").mangledNameHash());
    ASSERT_EQ(0x000003d0u, ImmutableString("texture(00u20B00B").mangledNameHash());
    ASSERT_EQ(0x000003d1u, ImmutableString("texture(00i20B00B").mangledNameHash());
    ASSERT_EQ(0x000003d2u, ImmutableString("texture(00f30B00B").mangledNameHash());
    ASSERT_EQ(0x000003d3u, ImmutableString("textureProj(00g10B00B").mangledNameHash());
    ASSERT_EQ(0x000003d4u, ImmutableString("textureProj(00o10B00B").mangledNameHash());
    ASSERT_EQ(0x000003d5u, ImmutableString("textureProj(00t10B00B").mangledNameHash());
    ASSERT_EQ(0x000003d6u, ImmutableString("textureProj(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x000003d7u, ImmutableString("textureProj(00o30B00B").mangledNameHash());
    ASSERT_EQ(0x000003d8u, ImmutableString("textureProj(00t30B00B").mangledNameHash());
    ASSERT_EQ(0x000003d9u, ImmutableString("textureProj(00m30B00B").mangledNameHash());
    ASSERT_EQ(0x000003dau, ImmutableString("texture(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x000003dbu, ImmutableString("texture(00s30B00B").mangledNameHash());
    ASSERT_EQ(0x000003dcu, ImmutableString("texture(00x30B00B").mangledNameHash());
    ASSERT_EQ(0x000003ddu, ImmutableString("texture(00M10B00B").mangledNameHash());
    ASSERT_EQ(0x000003deu, ImmutableString("textureProj(00M20B00B").mangledNameHash());
    ASSERT_EQ(0x000003dfu, ImmutableString("textureProj(00M30B00B").mangledNameHash());
    ASSERT_EQ(0x000003e0u, ImmutableString("texture(00N10B00B").mangledNameHash());
    ASSERT_EQ(0x000003e1u, ImmutableString("textureProj(00N20B00B").mangledNameHash());
    ASSERT_EQ(0x000003e2u, ImmutableString("textureProj(00N30B00B").mangledNameHash());
    ASSERT_EQ(0x000003e3u, ImmutableString("textureQueryLod(00g00B").mangledNameHash());
    ASSERT_EQ(0x000003e4u, ImmutableString("textureQueryLod(00o00B").mangledNameHash());
    ASSERT_EQ(0x000003e5u, ImmutableString("textureQueryLod(00t00B").mangledNameHash());
    ASSERT_EQ(0x000003e6u, ImmutableString("textureQueryLod(00I10B").mangledNameHash());
    ASSERT_EQ(0x000003e7u, ImmutableString("textureQueryLod(00R10B").mangledNameHash());
    ASSERT_EQ(0x000003e8u, ImmutableString("textureQueryLod(00X10B").mangledNameHash());
    ASSERT_EQ(0x000003e9u, ImmutableString("textureQueryLod(00J20B").mangledNameHash());
    ASSERT_EQ(0x000003eau, ImmutableString("textureQueryLod(00S20B").mangledNameHash());
    ASSERT_EQ(0x000003ebu, ImmutableString("textureQueryLod(00Y20B").mangledNameHash());
    ASSERT_EQ(0x000003ecu, ImmutableString("textureQueryLod(00K20B").mangledNameHash());
    ASSERT_EQ(0x000003edu, ImmutableString("textureQueryLod(00T20B").mangledNameHash());
    ASSERT_EQ(0x000003eeu, ImmutableString("textureQueryLod(00Z20B").mangledNameHash());
    ASSERT_EQ(0x000003efu, ImmutableString("textureQueryLod(00h00B").mangledNameHash());
    ASSERT_EQ(0x000003f0u, ImmutableString("textureQueryLod(00p00B").mangledNameHash());
    ASSERT_EQ(0x000003f1u, ImmutableString("textureQueryLod(00u00B").mangledNameHash());
    ASSERT_EQ(0x000003f2u, ImmutableString("textureQueryLod(00L10B").mangledNameHash());
    ASSERT_EQ(0x000003f3u, ImmutableString("textureQueryLod(00U10B").mangledNameHash());
    ASSERT_EQ(0x000003f4u, ImmutableString("textureQueryLod(00a10B").mangledNameHash());
    ASSERT_EQ(0x000003f5u, ImmutableString("textureQueryLod(00k20B").mangledNameHash());
    ASSERT_EQ(0x000003f6u, ImmutableString("textureQueryLod(00s20B").mangledNameHash());
    ASSERT_EQ(0x000003f7u, ImmutableString("textureQueryLod(00x20B").mangledNameHash());
    ASSERT_EQ(0x000003f8u, ImmutableString("textureQueryLod(00m00B").mangledNameHash());
    ASSERT_EQ(0x000003f9u, ImmutableString("textureQueryLod(00d10B").mangledNameHash());
    ASSERT_EQ(0x000003fau, ImmutableString("textureQueryLod(00e20B").mangledNameHash());
    ASSERT_EQ(0x000003fbu, ImmutableString("textureQueryLod(00i00B").mangledNameHash());
    ASSERT_EQ(0x000003fcu, ImmutableString("textureQueryLod(00f10B").mangledNameHash());
    ASSERT_EQ(0x000003fdu, ImmutableString("textureQueryLod(00l20B").mangledNameHash());
    ASSERT_EQ(0x000003feu, ImmutableString("textureOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x000003ffu, ImmutableString("textureOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x00000400u, ImmutableString("textureOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x00000401u, ImmutableString("textureOffset(00J20B20D").mangledNameHash());
    ASSERT_EQ(0x00000402u, ImmutableString("textureOffset(00S20B20D").mangledNameHash());
    ASSERT_EQ(0x00000403u, ImmutableString("textureOffset(00Y20B20D").mangledNameHash());
    ASSERT_EQ(0x00000404u, ImmutableString("textureOffset(00d20B10D").mangledNameHash());
    ASSERT_EQ(0x00000405u, ImmutableString("textureOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x00000406u, ImmutableString("textureOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x00000407u, ImmutableString("textureOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x00000408u, ImmutableString("textureOffset(00g00B00D").mangledNameHash());
    ASSERT_EQ(0x00000409u, ImmutableString("textureOffset(00o00B00D").mangledNameHash());
    ASSERT_EQ(0x0000040au, ImmutableString("textureOffset(00t00B00D").mangledNameHash());
    ASSERT_EQ(0x0000040bu, ImmutableString("textureOffset(00O10B10D").mangledNameHash());
    ASSERT_EQ(0x0000040cu, ImmutableString("textureOffset(00q10B10D").mangledNameHash());
    ASSERT_EQ(0x0000040du, ImmutableString("textureOffset(00v10B10D").mangledNameHash());
    ASSERT_EQ(0x0000040eu, ImmutableString("textureOffset(00n20B10D").mangledNameHash());
    ASSERT_EQ(0x0000040fu, ImmutableString("textureOffset(00m20B00D").mangledNameHash());
    ASSERT_EQ(0x00000410u, ImmutableString("textureOffset(00h10B00D").mangledNameHash());
    ASSERT_EQ(0x00000411u, ImmutableString("textureOffset(00p10B00D").mangledNameHash());
    ASSERT_EQ(0x00000412u, ImmutableString("textureOffset(00u10B00D").mangledNameHash());
    ASSERT_EQ(0x00000413u, ImmutableString("textureOffset(00i20B00D").mangledNameHash());
    ASSERT_EQ(0x00000414u, ImmutableString("textureOffset(00f30B10D").mangledNameHash());
    ASSERT_EQ(0x00000415u, ImmutableString("textureProjOffset(00I20B10D").mangledNameHash());
    ASSERT_EQ(0x00000416u, ImmutableString("textureProjOffset(00R20B10D").mangledNameHash());
    ASSERT_EQ(0x00000417u, ImmutableString("textureProjOffset(00X20B10D").mangledNameHash());
    ASSERT_EQ(0x00000418u, ImmutableString("textureProjOffset(00I30B10D").mangledNameHash());
    ASSERT_EQ(0x00000419u, ImmutableString("textureProjOffset(00R30B10D").mangledNameHash());
    ASSERT_EQ(0x0000041au, ImmutableString("textureProjOffset(00X30B10D").mangledNameHash());
    ASSERT_EQ(0x0000041bu, ImmutableString("textureProjOffset(00J30B20D").mangledNameHash());
    ASSERT_EQ(0x0000041cu, ImmutableString("textureProjOffset(00S30B20D").mangledNameHash());
    ASSERT_EQ(0x0000041du, ImmutableString("textureProjOffset(00Y30B20D").mangledNameHash());
    ASSERT_EQ(0x0000041eu, ImmutableString("textureProjOffset(00d30B10D").mangledNameHash());
    ASSERT_EQ(0x0000041fu, ImmutableString("textureProjOffset(00g10B00D").mangledNameHash());
    ASSERT_EQ(0x00000420u, ImmutableString("textureProjOffset(00o10B00D").mangledNameHash());
    ASSERT_EQ(0x00000421u, ImmutableString("textureProjOffset(00t10B00D").mangledNameHash());
    ASSERT_EQ(0x00000422u, ImmutableString("textureProjOffset(00g30B00D").mangledNameHash());
    ASSERT_EQ(0x00000423u, ImmutableString("textureProjOffset(00o30B00D").mangledNameHash());
    ASSERT_EQ(0x00000424u, ImmutableString("textureProjOffset(00t30B00D").mangledNameHash());
    ASSERT_EQ(0x00000425u, ImmutableString("textureProjOffset(00O20B10D").mangledNameHash());
    ASSERT_EQ(0x00000426u, ImmutableString("textureProjOffset(00q20B10D").mangledNameHash());
    ASSERT_EQ(0x00000427u, ImmutableString("textureProjOffset(00v20B10D").mangledNameHash());
    ASSERT_EQ(0x00000428u, ImmutableString("textureProjOffset(00O30B10D").mangledNameHash());
    ASSERT_EQ(0x00000429u, ImmutableString("textureProjOffset(00q30B10D").mangledNameHash());
    ASSERT_EQ(0x0000042au, ImmutableString("textureProjOffset(00v30B10D").mangledNameHash());
    ASSERT_EQ(0x0000042bu, ImmutableString("textureProjOffset(00n30B10D").mangledNameHash());
    ASSERT_EQ(0x0000042cu, ImmutableString("textureProjOffset(00m30B00D").mangledNameHash());
    ASSERT_EQ(0x0000042du, ImmutableString("textureLodOffset(00I10B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000042eu, ImmutableString("textureLodOffset(00R10B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000042fu, ImmutableString("textureLodOffset(00X10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000430u, ImmutableString("textureLodOffset(00J20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000431u, ImmutableString("textureLodOffset(00S20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000432u, ImmutableString("textureLodOffset(00Y20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000433u, ImmutableString("textureLodOffset(00d20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000434u, ImmutableString("textureLodOffset(00L20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000435u, ImmutableString("textureLodOffset(00U20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000436u, ImmutableString("textureLodOffset(00a20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000437u, ImmutableString("textureLodOffset(00g00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000438u, ImmutableString("textureLodOffset(00o00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000439u, ImmutableString("textureLodOffset(00t00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000043au, ImmutableString("textureLodOffset(00m20B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000043bu, ImmutableString("textureLodOffset(00h10B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000043cu, ImmutableString("textureLodOffset(00p10B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000043du, ImmutableString("textureLodOffset(00u10B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000043eu, ImmutableString("textureLodOffset(00i20B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000043fu, ImmutableString("textureProjLodOffset(00I20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000440u, ImmutableString("textureProjLodOffset(00R20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000441u, ImmutableString("textureProjLodOffset(00X20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000442u, ImmutableString("textureProjLodOffset(00I30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000443u, ImmutableString("textureProjLodOffset(00R30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000444u, ImmutableString("textureProjLodOffset(00X30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000445u, ImmutableString("textureProjLodOffset(00J30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000446u, ImmutableString("textureProjLodOffset(00S30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000447u, ImmutableString("textureProjLodOffset(00Y30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000448u, ImmutableString("textureProjLodOffset(00d30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000449u, ImmutableString("textureProjLodOffset(00g10B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000044au, ImmutableString("textureProjLodOffset(00o10B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000044bu, ImmutableString("textureProjLodOffset(00t10B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000044cu, ImmutableString("textureProjLodOffset(00g30B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000044du, ImmutableString("textureProjLodOffset(00o30B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000044eu, ImmutableString("textureProjLodOffset(00t30B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000044fu, ImmutableString("textureProjLodOffset(00m30B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000450u, ImmutableString("texelFetchOffset(00I10D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000451u, ImmutableString("texelFetchOffset(00R10D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000452u, ImmutableString("texelFetchOffset(00X10D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000453u, ImmutableString("texelFetchOffset(00J20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000454u, ImmutableString("texelFetchOffset(00S20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000455u, ImmutableString("texelFetchOffset(00Y20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000456u, ImmutableString("texelFetchOffset(00L20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000457u, ImmutableString("texelFetchOffset(00U20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000458u, ImmutableString("texelFetchOffset(00a20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000459u, ImmutableString("texelFetchOffset(00g00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000045au, ImmutableString("texelFetchOffset(00o00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000045bu, ImmutableString("texelFetchOffset(00t00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000045cu, ImmutableString("texelFetchOffset(00O10D10D").mangledNameHash());
    ASSERT_EQ(0x0000045du, ImmutableString("texelFetchOffset(00q10D10D").mangledNameHash());
    ASSERT_EQ(0x0000045eu, ImmutableString("texelFetchOffset(00v10D10D").mangledNameHash());
    ASSERT_EQ(0x0000045fu, ImmutableString("texelFetchOffset(00h10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000460u, ImmutableString("texelFetchOffset(00p10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000461u, ImmutableString("texelFetchOffset(00u10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000462u, ImmutableString("textureGradOffset(00I10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000463u, ImmutableString("textureGradOffset(00R10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000464u, ImmutableString("textureGradOffset(00X10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000465u, ImmutableString("textureGradOffset(00J20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000466u, ImmutableString("textureGradOffset(00S20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000467u, ImmutableString("textureGradOffset(00Y20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000468u, ImmutableString("textureGradOffset(00d20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000469u, ImmutableString("textureGradOffset(00L20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000046au, ImmutableString("textureGradOffset(00U20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000046bu, ImmutableString("textureGradOffset(00a20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000046cu, ImmutableString("textureGradOffset(00f30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000046du, ImmutableString("textureGradOffset(00g00B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000046eu, ImmutableString("textureGradOffset(00o00B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x0000046fu, ImmutableString("textureGradOffset(00t00B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000470u, ImmutableString("textureGradOffset(00O10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000471u, ImmutableString("textureGradOffset(00q10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000472u, ImmutableString("textureGradOffset(00v10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000473u, ImmutableString("textureGradOffset(00n20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000474u, ImmutableString("textureGradOffset(00m20B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000475u, ImmutableString("textureGradOffset(00h10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000476u, ImmutableString("textureGradOffset(00p10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000477u, ImmutableString("textureGradOffset(00u10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000478u, ImmutableString("textureGradOffset(00i20B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000479u,
              ImmutableString("textureProjGradOffset(00I20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000047au,
              ImmutableString("textureProjGradOffset(00R20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000047bu,
              ImmutableString("textureProjGradOffset(00X20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000047cu,
              ImmutableString("textureProjGradOffset(00I30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000047du,
              ImmutableString("textureProjGradOffset(00R30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000047eu,
              ImmutableString("textureProjGradOffset(00X30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000047fu,
              ImmutableString("textureProjGradOffset(00J30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000480u,
              ImmutableString("textureProjGradOffset(00S30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000481u,
              ImmutableString("textureProjGradOffset(00Y30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000482u,
              ImmutableString("textureProjGradOffset(00d30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000483u,
              ImmutableString("textureProjGradOffset(00g10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000484u,
              ImmutableString("textureProjGradOffset(00o10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000485u,
              ImmutableString("textureProjGradOffset(00t10B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000486u,
              ImmutableString("textureProjGradOffset(00g30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000487u,
              ImmutableString("textureProjGradOffset(00o30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000488u,
              ImmutableString("textureProjGradOffset(00t30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000489u,
              ImmutableString("textureProjGradOffset(00O20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000048au,
              ImmutableString("textureProjGradOffset(00q20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000048bu,
              ImmutableString("textureProjGradOffset(00v20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000048cu,
              ImmutableString("textureProjGradOffset(00O30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000048du,
              ImmutableString("textureProjGradOffset(00q30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000048eu,
              ImmutableString("textureProjGradOffset(00v30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000048fu,
              ImmutableString("textureProjGradOffset(00n30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000490u,
              ImmutableString("textureProjGradOffset(00m30B00B00B00D").mangledNameHash());
    ASSERT_EQ(0x00000491u, ImmutableString("textureOffset(00I10B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000492u, ImmutableString("textureOffset(00R10B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000493u, ImmutableString("textureOffset(00X10B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000494u, ImmutableString("textureOffset(00J20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000495u, ImmutableString("textureOffset(00S20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000496u, ImmutableString("textureOffset(00Y20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000497u, ImmutableString("textureOffset(00d20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000498u, ImmutableString("textureOffset(00L20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000499u, ImmutableString("textureOffset(00U20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000049au, ImmutableString("textureOffset(00a20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000049bu, ImmutableString("textureOffset(00g00B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000049cu, ImmutableString("textureOffset(00o00B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000049du, ImmutableString("textureOffset(00t00B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000049eu, ImmutableString("textureOffset(00m20B00D00B").mangledNameHash());
    ASSERT_EQ(0x0000049fu, ImmutableString("textureOffset(00h10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004a0u, ImmutableString("textureOffset(00p10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004a1u, ImmutableString("textureOffset(00u10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004a2u, ImmutableString("textureOffset(00i20B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004a3u, ImmutableString("textureProjOffset(00I20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004a4u, ImmutableString("textureProjOffset(00R20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004a5u, ImmutableString("textureProjOffset(00X20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004a6u, ImmutableString("textureProjOffset(00I30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004a7u, ImmutableString("textureProjOffset(00R30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004a8u, ImmutableString("textureProjOffset(00X30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004a9u, ImmutableString("textureProjOffset(00J30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000004aau, ImmutableString("textureProjOffset(00S30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000004abu, ImmutableString("textureProjOffset(00Y30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000004acu, ImmutableString("textureProjOffset(00d30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000004adu, ImmutableString("textureProjOffset(00g10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004aeu, ImmutableString("textureProjOffset(00o10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004afu, ImmutableString("textureProjOffset(00t10B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004b0u, ImmutableString("textureProjOffset(00g30B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004b1u, ImmutableString("textureProjOffset(00o30B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004b2u, ImmutableString("textureProjOffset(00t30B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004b3u, ImmutableString("textureProjOffset(00m30B00D00B").mangledNameHash());
    ASSERT_EQ(0x000004b4u, ImmutableString("textureGather(00I10B").mangledNameHash());
    ASSERT_EQ(0x000004b5u, ImmutableString("textureGather(00R10B").mangledNameHash());
    ASSERT_EQ(0x000004b6u, ImmutableString("textureGather(00X10B").mangledNameHash());
    ASSERT_EQ(0x000004b7u, ImmutableString("textureGather(00I10B00D").mangledNameHash());
    ASSERT_EQ(0x000004b8u, ImmutableString("textureGather(00R10B00D").mangledNameHash());
    ASSERT_EQ(0x000004b9u, ImmutableString("textureGather(00X10B00D").mangledNameHash());
    ASSERT_EQ(0x000004bau, ImmutableString("textureGather(00L20B").mangledNameHash());
    ASSERT_EQ(0x000004bbu, ImmutableString("textureGather(00U20B").mangledNameHash());
    ASSERT_EQ(0x000004bcu, ImmutableString("textureGather(00a20B").mangledNameHash());
    ASSERT_EQ(0x000004bdu, ImmutableString("textureGather(00L20B00D").mangledNameHash());
    ASSERT_EQ(0x000004beu, ImmutableString("textureGather(00U20B00D").mangledNameHash());
    ASSERT_EQ(0x000004bfu, ImmutableString("textureGather(00a20B00D").mangledNameHash());
    ASSERT_EQ(0x000004c0u, ImmutableString("textureGather(00K20B").mangledNameHash());
    ASSERT_EQ(0x000004c1u, ImmutableString("textureGather(00T20B").mangledNameHash());
    ASSERT_EQ(0x000004c2u, ImmutableString("textureGather(00Z20B").mangledNameHash());
    ASSERT_EQ(0x000004c3u, ImmutableString("textureGather(00K20B00D").mangledNameHash());
    ASSERT_EQ(0x000004c4u, ImmutableString("textureGather(00T20B00D").mangledNameHash());
    ASSERT_EQ(0x000004c5u, ImmutableString("textureGather(00Z20B00D").mangledNameHash());
    ASSERT_EQ(0x000004c6u, ImmutableString("textureGather(00k30B").mangledNameHash());
    ASSERT_EQ(0x000004c7u, ImmutableString("textureGather(00s30B").mangledNameHash());
    ASSERT_EQ(0x000004c8u, ImmutableString("textureGather(00x30B").mangledNameHash());
    ASSERT_EQ(0x000004c9u, ImmutableString("textureGather(00k30B00D").mangledNameHash());
    ASSERT_EQ(0x000004cau, ImmutableString("textureGather(00s30B00D").mangledNameHash());
    ASSERT_EQ(0x000004cbu, ImmutableString("textureGather(00x30B00D").mangledNameHash());
    ASSERT_EQ(0x000004ccu, ImmutableString("textureGather(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x000004cdu, ImmutableString("textureGather(00O20B").mangledNameHash());
    ASSERT_EQ(0x000004ceu, ImmutableString("textureGather(00q20B").mangledNameHash());
    ASSERT_EQ(0x000004cfu, ImmutableString("textureGather(00v20B").mangledNameHash());
    ASSERT_EQ(0x000004d0u, ImmutableString("textureGather(00O20B00D").mangledNameHash());
    ASSERT_EQ(0x000004d1u, ImmutableString("textureGather(00q20B00D").mangledNameHash());
    ASSERT_EQ(0x000004d2u, ImmutableString("textureGather(00v20B00D").mangledNameHash());
    ASSERT_EQ(0x000004d3u, ImmutableString("textureGather(00n10B00B").mangledNameHash());
    ASSERT_EQ(0x000004d4u, ImmutableString("textureGather(00d10B").mangledNameHash());
    ASSERT_EQ(0x000004d5u, ImmutableString("textureGather(00d10B00B").mangledNameHash());
    ASSERT_EQ(0x000004d6u, ImmutableString("textureGather(00f20B").mangledNameHash());
    ASSERT_EQ(0x000004d7u, ImmutableString("textureGather(00f20B00B").mangledNameHash());
    ASSERT_EQ(0x000004d8u, ImmutableString("textureGather(00e20B").mangledNameHash());
    ASSERT_EQ(0x000004d9u, ImmutableString("textureGather(00e20B00B").mangledNameHash());
    ASSERT_EQ(0x000004dau, ImmutableString("textureGatherOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x000004dbu, ImmutableString("textureGatherOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x000004dcu, ImmutableString("textureGatherOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x000004ddu, ImmutableString("textureGatherOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x000004deu, ImmutableString("textureGatherOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x000004dfu, ImmutableString("textureGatherOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x000004e0u, ImmutableString("textureGatherOffset(00d10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000004e1u, ImmutableString("textureGatherOffset(00f20B00B10D").mangledNameHash());
    ASSERT_EQ(0x000004e2u, ImmutableString("textureGatherOffset(00O10B10D").mangledNameHash());
    ASSERT_EQ(0x000004e3u, ImmutableString("textureGatherOffset(00q10B10D").mangledNameHash());
    ASSERT_EQ(0x000004e4u, ImmutableString("textureGatherOffset(00v10B10D").mangledNameHash());
    ASSERT_EQ(0x000004e5u, ImmutableString("textureGatherOffset(00n10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000004e6u, ImmutableString("textureGatherOffset(00I10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004e7u, ImmutableString("textureGatherOffset(00R10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004e8u, ImmutableString("textureGatherOffset(00X10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004e9u, ImmutableString("textureGatherOffset(00L20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004eau, ImmutableString("textureGatherOffset(00U20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004ebu, ImmutableString("textureGatherOffset(00a20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004ecu, ImmutableString("textureGatherOffset(00O10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004edu, ImmutableString("textureGatherOffset(00q10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004eeu, ImmutableString("textureGatherOffset(00v10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000004efu, ImmutableString("textureGatherOffsets(00I10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f0u, ImmutableString("textureGatherOffsets(00R10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f1u, ImmutableString("textureGatherOffsets(00X10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f2u, ImmutableString("textureGatherOffsets(00L20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f3u, ImmutableString("textureGatherOffsets(00U20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f4u, ImmutableString("textureGatherOffsets(00a20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f5u,
              ImmutableString("textureGatherOffsets(00d10B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f6u,
              ImmutableString("textureGatherOffsets(00f20B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f7u, ImmutableString("textureGatherOffsets(00O10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f8u, ImmutableString("textureGatherOffsets(00q10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004f9u, ImmutableString("textureGatherOffsets(00v10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004fau,
              ImmutableString("textureGatherOffsets(00n10B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000004fbu,
              ImmutableString("textureGatherOffsets(00I10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000004fcu,
              ImmutableString("textureGatherOffsets(00R10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000004fdu,
              ImmutableString("textureGatherOffsets(00X10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000004feu,
              ImmutableString("textureGatherOffsets(00L20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000004ffu,
              ImmutableString("textureGatherOffsets(00U20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000500u,
              ImmutableString("textureGatherOffsets(00a20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000501u,
              ImmutableString("textureGatherOffsets(00O10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000502u,
              ImmutableString("textureGatherOffsets(00q10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000503u,
              ImmutableString("textureGatherOffsets(00v10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000504u, ImmutableString("rgb_2_yuv(20B00H").mangledNameHash());
    ASSERT_EQ(0x00000505u, ImmutableString("yuv_2_rgb(20B00H").mangledNameHash());
    ASSERT_EQ(0x00000506u, ImmutableString("dFdx(00B").mangledNameHash());
    ASSERT_EQ(0x00000507u, ImmutableString("dFdx(10B").mangledNameHash());
    ASSERT_EQ(0x00000508u, ImmutableString("dFdx(20B").mangledNameHash());
    ASSERT_EQ(0x00000509u, ImmutableString("dFdx(30B").mangledNameHash());
    ASSERT_EQ(0x0000050au, ImmutableString("dFdy(00B").mangledNameHash());
    ASSERT_EQ(0x0000050bu, ImmutableString("dFdy(10B").mangledNameHash());
    ASSERT_EQ(0x0000050cu, ImmutableString("dFdy(20B").mangledNameHash());
    ASSERT_EQ(0x0000050du, ImmutableString("dFdy(30B").mangledNameHash());
    ASSERT_EQ(0x0000050eu, ImmutableString("fwidth(00B").mangledNameHash());
    ASSERT_EQ(0x0000050fu, ImmutableString("fwidth(10B").mangledNameHash());
    ASSERT_EQ(0x00000510u, ImmutableString("fwidth(20B").mangledNameHash());
    ASSERT_EQ(0x00000511u, ImmutableString("fwidth(30B").mangledNameHash());
    ASSERT_EQ(0x00000512u, ImmutableString("dFdxFine(00B").mangledNameHash());
    ASSERT_EQ(0x00000513u, ImmutableString("dFdxFine(10B").mangledNameHash());
    ASSERT_EQ(0x00000514u, ImmutableString("dFdxFine(20B").mangledNameHash());
    ASSERT_EQ(0x00000515u, ImmutableString("dFdxFine(30B").mangledNameHash());
    ASSERT_EQ(0x00000516u, ImmutableString("dFdyFine(00B").mangledNameHash());
    ASSERT_EQ(0x00000517u, ImmutableString("dFdyFine(10B").mangledNameHash());
    ASSERT_EQ(0x00000518u, ImmutableString("dFdyFine(20B").mangledNameHash());
    ASSERT_EQ(0x00000519u, ImmutableString("dFdyFine(30B").mangledNameHash());
    ASSERT_EQ(0x0000051au, ImmutableString("dFdxCoarse(00B").mangledNameHash());
    ASSERT_EQ(0x0000051bu, ImmutableString("dFdxCoarse(10B").mangledNameHash());
    ASSERT_EQ(0x0000051cu, ImmutableString("dFdxCoarse(20B").mangledNameHash());
    ASSERT_EQ(0x0000051du, ImmutableString("dFdxCoarse(30B").mangledNameHash());
    ASSERT_EQ(0x0000051eu, ImmutableString("dFdyCoarse(00B").mangledNameHash());
    ASSERT_EQ(0x0000051fu, ImmutableString("dFdyCoarse(10B").mangledNameHash());
    ASSERT_EQ(0x00000520u, ImmutableString("dFdyCoarse(20B").mangledNameHash());
    ASSERT_EQ(0x00000521u, ImmutableString("dFdyCoarse(30B").mangledNameHash());
    ASSERT_EQ(0x00000522u, ImmutableString("fwidthFine(00B").mangledNameHash());
    ASSERT_EQ(0x00000523u, ImmutableString("fwidthFine(10B").mangledNameHash());
    ASSERT_EQ(0x00000524u, ImmutableString("fwidthFine(20B").mangledNameHash());
    ASSERT_EQ(0x00000525u, ImmutableString("fwidthFine(30B").mangledNameHash());
    ASSERT_EQ(0x00000526u, ImmutableString("fwidthCoarse(00B").mangledNameHash());
    ASSERT_EQ(0x00000527u, ImmutableString("fwidthCoarse(10B").mangledNameHash());
    ASSERT_EQ(0x00000528u, ImmutableString("fwidthCoarse(20B").mangledNameHash());
    ASSERT_EQ(0x00000529u, ImmutableString("fwidthCoarse(30B").mangledNameHash());
    ASSERT_EQ(0x0000052au, ImmutableString("interpolateAtCentroid(00B").mangledNameHash());
    ASSERT_EQ(0x0000052bu, ImmutableString("interpolateAtCentroid(10B").mangledNameHash());
    ASSERT_EQ(0x0000052cu, ImmutableString("interpolateAtCentroid(20B").mangledNameHash());
    ASSERT_EQ(0x0000052du, ImmutableString("interpolateAtCentroid(30B").mangledNameHash());
    ASSERT_EQ(0x0000052eu, ImmutableString("interpolateAtSample(00B00D").mangledNameHash());
    ASSERT_EQ(0x0000052fu, ImmutableString("interpolateAtSample(10B00D").mangledNameHash());
    ASSERT_EQ(0x00000530u, ImmutableString("interpolateAtSample(20B00D").mangledNameHash());
    ASSERT_EQ(0x00000531u, ImmutableString("interpolateAtSample(30B00D").mangledNameHash());
    ASSERT_EQ(0x00000532u, ImmutableString("interpolateAtOffset(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000533u, ImmutableString("interpolateAtOffset(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000534u, ImmutableString("interpolateAtOffset(20B10B").mangledNameHash());
    ASSERT_EQ(0x00000535u, ImmutableString("interpolateAtOffset(30B10B").mangledNameHash());
    ASSERT_EQ(0x00000536u, ImmutableString("atomicCounter(00G").mangledNameHash());
    ASSERT_EQ(0x00000537u, ImmutableString("atomicCounterIncrement(00G").mangledNameHash());
    ASSERT_EQ(0x00000538u, ImmutableString("atomicCounterDecrement(00G").mangledNameHash());
    ASSERT_EQ(0x00000539u, ImmutableString("atomicCounterAdd(00G00E").mangledNameHash());
    ASSERT_EQ(0x0000053au, ImmutableString("atomicCounterSubtract(00G00E").mangledNameHash());
    ASSERT_EQ(0x0000053bu, ImmutableString("atomicCounterMin(00G00E").mangledNameHash());
    ASSERT_EQ(0x0000053cu, ImmutableString("atomicCounterMax(00G00E").mangledNameHash());
    ASSERT_EQ(0x0000053du, ImmutableString("atomicCounterAnd(00G00E").mangledNameHash());
    ASSERT_EQ(0x0000053eu, ImmutableString("atomicCounterOr(00G00E").mangledNameHash());
    ASSERT_EQ(0x0000053fu, ImmutableString("atomicCounterXor(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000540u, ImmutableString("atomicCounterExchange(00G00E").mangledNameHash());
    ASSERT_EQ(0x00000541u, ImmutableString("atomicCounterCompSwap(00G00E00E").mangledNameHash());
    ASSERT_EQ(0x00000542u, ImmutableString("atomicAdd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000543u, ImmutableString("atomicAdd(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000544u, ImmutableString("atomicMin(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000545u, ImmutableString("atomicMin(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000546u, ImmutableString("atomicMax(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000547u, ImmutableString("atomicMax(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000548u, ImmutableString("atomicAnd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000549u, ImmutableString("atomicAnd(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000054au, ImmutableString("atomicOr(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000054bu, ImmutableString("atomicOr(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000054cu, ImmutableString("atomicXor(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000054du, ImmutableString("atomicXor(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000054eu, ImmutableString("atomicExchange(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000054fu, ImmutableString("atomicExchange(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000550u, ImmutableString("atomicCompSwap(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000551u, ImmutableString("atomicCompSwap(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000552u, ImmutableString("imageSize(00z").mangledNameHash());
    ASSERT_EQ(0x00000553u, ImmutableString("imageSize(01K").mangledNameHash());
    ASSERT_EQ(0x00000554u, ImmutableString("imageSize(01V").mangledNameHash());
    ASSERT_EQ(0x00000555u, ImmutableString("imageSize(01A").mangledNameHash());
    ASSERT_EQ(0x00000556u, ImmutableString("imageSize(01L").mangledNameHash());
    ASSERT_EQ(0x00000557u, ImmutableString("imageSize(01W").mangledNameHash());
    ASSERT_EQ(0x00000558u, ImmutableString("imageSize(01B").mangledNameHash());
    ASSERT_EQ(0x00000559u, ImmutableString("imageSize(01M").mangledNameHash());
    ASSERT_EQ(0x0000055au, ImmutableString("imageSize(01X").mangledNameHash());
    ASSERT_EQ(0x0000055bu, ImmutableString("imageSize(01C").mangledNameHash());
    ASSERT_EQ(0x0000055cu, ImmutableString("imageSize(01N").mangledNameHash());
    ASSERT_EQ(0x0000055du, ImmutableString("imageSize(01Y").mangledNameHash());
    ASSERT_EQ(0x0000055eu, ImmutableString("imageSize(01H").mangledNameHash());
    ASSERT_EQ(0x0000055fu, ImmutableString("imageSize(01S").mangledNameHash());
    ASSERT_EQ(0x00000560u, ImmutableString("imageSize(01d").mangledNameHash());
    ASSERT_EQ(0x00000561u, ImmutableString("imageSize(01J").mangledNameHash());
    ASSERT_EQ(0x00000562u, ImmutableString("imageSize(01U").mangledNameHash());
    ASSERT_EQ(0x00000563u, ImmutableString("imageSize(01f").mangledNameHash());
    ASSERT_EQ(0x00000564u, ImmutableString("imageSize(01D").mangledNameHash());
    ASSERT_EQ(0x00000565u, ImmutableString("imageSize(01O").mangledNameHash());
    ASSERT_EQ(0x00000566u, ImmutableString("imageSize(01Z").mangledNameHash());
    ASSERT_EQ(0x00000567u, ImmutableString("imageSize(01I").mangledNameHash());
    ASSERT_EQ(0x00000568u, ImmutableString("imageSize(01T").mangledNameHash());
    ASSERT_EQ(0x00000569u, ImmutableString("imageSize(01e").mangledNameHash());
    ASSERT_EQ(0x0000056au, ImmutableString("imageSize(01E").mangledNameHash());
    ASSERT_EQ(0x0000056bu, ImmutableString("imageSize(01P").mangledNameHash());
    ASSERT_EQ(0x0000056cu, ImmutableString("imageSize(01a").mangledNameHash());
    ASSERT_EQ(0x0000056du, ImmutableString("imageSize(01F").mangledNameHash());
    ASSERT_EQ(0x0000056eu, ImmutableString("imageSize(01Q").mangledNameHash());
    ASSERT_EQ(0x0000056fu, ImmutableString("imageSize(01b").mangledNameHash());
    ASSERT_EQ(0x00000570u, ImmutableString("imageSize(01G").mangledNameHash());
    ASSERT_EQ(0x00000571u, ImmutableString("imageSize(01R").mangledNameHash());
    ASSERT_EQ(0x00000572u, ImmutableString("imageSize(01c").mangledNameHash());
    ASSERT_EQ(0x00000573u, ImmutableString("imageSamples(01F").mangledNameHash());
    ASSERT_EQ(0x00000574u, ImmutableString("imageSamples(01Q").mangledNameHash());
    ASSERT_EQ(0x00000575u, ImmutableString("imageSamples(01b").mangledNameHash());
    ASSERT_EQ(0x00000576u, ImmutableString("imageSamples(01G").mangledNameHash());
    ASSERT_EQ(0x00000577u, ImmutableString("imageSamples(01R").mangledNameHash());
    ASSERT_EQ(0x00000578u, ImmutableString("imageSamples(01c").mangledNameHash());
    ASSERT_EQ(0x00000579u, ImmutableString("imageStore(00z10D30B").mangledNameHash());
    ASSERT_EQ(0x0000057au, ImmutableString("imageStore(01K10D30D").mangledNameHash());
    ASSERT_EQ(0x0000057bu, ImmutableString("imageStore(01V10D30E").mangledNameHash());
    ASSERT_EQ(0x0000057cu, ImmutableString("imageStore(01A20D30B").mangledNameHash());
    ASSERT_EQ(0x0000057du, ImmutableString("imageStore(01L20D30D").mangledNameHash());
    ASSERT_EQ(0x0000057eu, ImmutableString("imageStore(01W20D30E").mangledNameHash());
    ASSERT_EQ(0x0000057fu, ImmutableString("imageStore(01B20D30B").mangledNameHash());
    ASSERT_EQ(0x00000580u, ImmutableString("imageStore(01M20D30D").mangledNameHash());
    ASSERT_EQ(0x00000581u, ImmutableString("imageStore(01X20D30E").mangledNameHash());
    ASSERT_EQ(0x00000582u, ImmutableString("imageStore(01C20D30B").mangledNameHash());
    ASSERT_EQ(0x00000583u, ImmutableString("imageStore(01N20D30D").mangledNameHash());
    ASSERT_EQ(0x00000584u, ImmutableString("imageStore(01Y20D30E").mangledNameHash());
    ASSERT_EQ(0x00000585u, ImmutableString("imageStore(01H20D30B").mangledNameHash());
    ASSERT_EQ(0x00000586u, ImmutableString("imageStore(01S20D30D").mangledNameHash());
    ASSERT_EQ(0x00000587u, ImmutableString("imageStore(01d20D30E").mangledNameHash());
    ASSERT_EQ(0x00000588u, ImmutableString("imageStore(01J00D30B").mangledNameHash());
    ASSERT_EQ(0x00000589u, ImmutableString("imageStore(01U00D30D").mangledNameHash());
    ASSERT_EQ(0x0000058au, ImmutableString("imageStore(01f00D30E").mangledNameHash());
    ASSERT_EQ(0x0000058bu, ImmutableString("imageStore(01D00D30B").mangledNameHash());
    ASSERT_EQ(0x0000058cu, ImmutableString("imageStore(01O00D30D").mangledNameHash());
    ASSERT_EQ(0x0000058du, ImmutableString("imageStore(01Z00D30E").mangledNameHash());
    ASSERT_EQ(0x0000058eu, ImmutableString("imageStore(01E10D30B").mangledNameHash());
    ASSERT_EQ(0x0000058fu, ImmutableString("imageStore(01P10D30D").mangledNameHash());
    ASSERT_EQ(0x00000590u, ImmutableString("imageStore(01a10D30E").mangledNameHash());
    ASSERT_EQ(0x00000591u, ImmutableString("imageStore(01I10D30B").mangledNameHash());
    ASSERT_EQ(0x00000592u, ImmutableString("imageStore(01T10D30D").mangledNameHash());
    ASSERT_EQ(0x00000593u, ImmutableString("imageStore(01e10D30E").mangledNameHash());
    ASSERT_EQ(0x00000594u, ImmutableString("imageStore(01F10D00D30B").mangledNameHash());
    ASSERT_EQ(0x00000595u, ImmutableString("imageStore(01Q10D00D30D").mangledNameHash());
    ASSERT_EQ(0x00000596u, ImmutableString("imageStore(01b10D00D30E").mangledNameHash());
    ASSERT_EQ(0x00000597u, ImmutableString("imageStore(01G20D00D30B").mangledNameHash());
    ASSERT_EQ(0x00000598u, ImmutableString("imageStore(01R20D00D30D").mangledNameHash());
    ASSERT_EQ(0x00000599u, ImmutableString("imageStore(01c20D00D30E").mangledNameHash());
    ASSERT_EQ(0x0000059au, ImmutableString("imageLoad(00z10D").mangledNameHash());
    ASSERT_EQ(0x0000059bu, ImmutableString("imageLoad(01K10D").mangledNameHash());
    ASSERT_EQ(0x0000059cu, ImmutableString("imageLoad(01V10D").mangledNameHash());
    ASSERT_EQ(0x0000059du, ImmutableString("imageLoad(01A20D").mangledNameHash());
    ASSERT_EQ(0x0000059eu, ImmutableString("imageLoad(01L20D").mangledNameHash());
    ASSERT_EQ(0x0000059fu, ImmutableString("imageLoad(01W20D").mangledNameHash());
    ASSERT_EQ(0x000005a0u, ImmutableString("imageLoad(01B20D").mangledNameHash());
    ASSERT_EQ(0x000005a1u, ImmutableString("imageLoad(01M20D").mangledNameHash());
    ASSERT_EQ(0x000005a2u, ImmutableString("imageLoad(01X20D").mangledNameHash());
    ASSERT_EQ(0x000005a3u, ImmutableString("imageLoad(01C20D").mangledNameHash());
    ASSERT_EQ(0x000005a4u, ImmutableString("imageLoad(01N20D").mangledNameHash());
    ASSERT_EQ(0x000005a5u, ImmutableString("imageLoad(01Y20D").mangledNameHash());
    ASSERT_EQ(0x000005a6u, ImmutableString("imageLoad(01H20D").mangledNameHash());
    ASSERT_EQ(0x000005a7u, ImmutableString("imageLoad(01S20D").mangledNameHash());
    ASSERT_EQ(0x000005a8u, ImmutableString("imageLoad(01d20D").mangledNameHash());
    ASSERT_EQ(0x000005a9u, ImmutableString("imageLoad(01J00D").mangledNameHash());
    ASSERT_EQ(0x000005aau, ImmutableString("imageLoad(01U00D").mangledNameHash());
    ASSERT_EQ(0x000005abu, ImmutableString("imageLoad(01f00D").mangledNameHash());
    ASSERT_EQ(0x000005acu, ImmutableString("imageLoad(01D00D").mangledNameHash());
    ASSERT_EQ(0x000005adu, ImmutableString("imageLoad(01O00D").mangledNameHash());
    ASSERT_EQ(0x000005aeu, ImmutableString("imageLoad(01Z00D").mangledNameHash());
    ASSERT_EQ(0x000005afu, ImmutableString("imageLoad(01E10D").mangledNameHash());
    ASSERT_EQ(0x000005b0u, ImmutableString("imageLoad(01P10D").mangledNameHash());
    ASSERT_EQ(0x000005b1u, ImmutableString("imageLoad(01a10D").mangledNameHash());
    ASSERT_EQ(0x000005b2u, ImmutableString("imageLoad(01I10D").mangledNameHash());
    ASSERT_EQ(0x000005b3u, ImmutableString("imageLoad(01T10D").mangledNameHash());
    ASSERT_EQ(0x000005b4u, ImmutableString("imageLoad(01e10D").mangledNameHash());
    ASSERT_EQ(0x000005b5u, ImmutableString("imageLoad(01F10D00D").mangledNameHash());
    ASSERT_EQ(0x000005b6u, ImmutableString("imageLoad(01Q10D00D").mangledNameHash());
    ASSERT_EQ(0x000005b7u, ImmutableString("imageLoad(01b10D00D").mangledNameHash());
    ASSERT_EQ(0x000005b8u, ImmutableString("imageLoad(01G20D00D").mangledNameHash());
    ASSERT_EQ(0x000005b9u, ImmutableString("imageLoad(01R20D00D").mangledNameHash());
    ASSERT_EQ(0x000005bau, ImmutableString("imageLoad(01c20D00D").mangledNameHash());
    ASSERT_EQ(0x000005bbu, ImmutableString("imageAtomicAdd(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000005bcu, ImmutableString("imageAtomicAdd(01K10D00E").mangledNameHash());
    ASSERT_EQ(0x000005bdu, ImmutableString("imageAtomicAdd(01V10D00E").mangledNameHash());
    ASSERT_EQ(0x000005beu, ImmutableString("imageAtomicAdd(01A20D00E").mangledNameHash());
    ASSERT_EQ(0x000005bfu, ImmutableString("imageAtomicAdd(01L20D00E").mangledNameHash());
    ASSERT_EQ(0x000005c0u, ImmutableString("imageAtomicAdd(01W20D00E").mangledNameHash());
    ASSERT_EQ(0x000005c1u, ImmutableString("imageAtomicAdd(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x000005c2u, ImmutableString("imageAtomicAdd(01N20D00E").mangledNameHash());
    ASSERT_EQ(0x000005c3u, ImmutableString("imageAtomicAdd(01Y20D00E").mangledNameHash());
    ASSERT_EQ(0x000005c4u, ImmutableString("imageAtomicAdd(01J00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c5u, ImmutableString("imageAtomicAdd(01U00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c6u, ImmutableString("imageAtomicAdd(01f00D00E").mangledNameHash());
    ASSERT_EQ(0x000005c7u, ImmutableString("imageAtomicAdd(01B20D00E").mangledNameHash());
    ASSERT_EQ(0x000005c8u, ImmutableString("imageAtomicAdd(01M20D00E").mangledNameHash());
    ASSERT_EQ(0x000005c9u, ImmutableString("imageAtomicAdd(01X20D00E").mangledNameHash());
    ASSERT_EQ(0x000005cau, ImmutableString("imageAtomicAdd(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000005cbu, ImmutableString("imageAtomicAdd(01S20D00E").mangledNameHash());
    ASSERT_EQ(0x000005ccu, ImmutableString("imageAtomicAdd(01d20D00E").mangledNameHash());
    ASSERT_EQ(0x000005cdu, ImmutableString("imageAtomicAdd(01D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005ceu, ImmutableString("imageAtomicAdd(01O00D00E").mangledNameHash());
    ASSERT_EQ(0x000005cfu, ImmutableString("imageAtomicAdd(01Z00D00E").mangledNameHash());
    ASSERT_EQ(0x000005d0u, ImmutableString("imageAtomicAdd(01E10D00E").mangledNameHash());
    ASSERT_EQ(0x000005d1u, ImmutableString("imageAtomicAdd(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x000005d2u, ImmutableString("imageAtomicAdd(01a10D00E").mangledNameHash());
    ASSERT_EQ(0x000005d3u, ImmutableString("imageAtomicAdd(01I10D00E").mangledNameHash());
    ASSERT_EQ(0x000005d4u, ImmutableString("imageAtomicAdd(01T10D00E").mangledNameHash());
    ASSERT_EQ(0x000005d5u, ImmutableString("imageAtomicAdd(01e10D00E").mangledNameHash());
    ASSERT_EQ(0x000005d6u, ImmutableString("imageAtomicAdd(01F10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005d7u, ImmutableString("imageAtomicAdd(01Q10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005d8u, ImmutableString("imageAtomicAdd(01b10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005d9u, ImmutableString("imageAtomicAdd(01G20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005dau, ImmutableString("imageAtomicAdd(01R20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005dbu, ImmutableString("imageAtomicAdd(01c20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000005dcu, ImmutableString("imageAtomicAdd(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x000005ddu, ImmutableString("imageAtomicAdd(01K10D00D").mangledNameHash());
    ASSERT_EQ(0x000005deu, ImmutableString("imageAtomicAdd(01V10D00D").mangledNameHash());
    ASSERT_EQ(0x000005dfu, ImmutableString("imageAtomicAdd(01A20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e0u, ImmutableString("imageAtomicAdd(01L20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e1u, ImmutableString("imageAtomicAdd(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e2u, ImmutableString("imageAtomicAdd(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e3u, ImmutableString("imageAtomicAdd(01N20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e4u, ImmutableString("imageAtomicAdd(01Y20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e5u, ImmutableString("imageAtomicAdd(01J00D00D").mangledNameHash());
    ASSERT_EQ(0x000005e6u, ImmutableString("imageAtomicAdd(01U00D00D").mangledNameHash());
    ASSERT_EQ(0x000005e7u, ImmutableString("imageAtomicAdd(01f00D00D").mangledNameHash());
    ASSERT_EQ(0x000005e8u, ImmutableString("imageAtomicAdd(01B20D00D").mangledNameHash());
    ASSERT_EQ(0x000005e9u, ImmutableString("imageAtomicAdd(01M20D00D").mangledNameHash());
    ASSERT_EQ(0x000005eau, ImmutableString("imageAtomicAdd(01X20D00D").mangledNameHash());
    ASSERT_EQ(0x000005ebu, ImmutableString("imageAtomicAdd(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000005ecu, ImmutableString("imageAtomicAdd(01S20D00D").mangledNameHash());
    ASSERT_EQ(0x000005edu, ImmutableString("imageAtomicAdd(01d20D00D").mangledNameHash());
    ASSERT_EQ(0x000005eeu, ImmutableString("imageAtomicAdd(01D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005efu, ImmutableString("imageAtomicAdd(01O00D00D").mangledNameHash());
    ASSERT_EQ(0x000005f0u, ImmutableString("imageAtomicAdd(01Z00D00D").mangledNameHash());
    ASSERT_EQ(0x000005f1u, ImmutableString("imageAtomicAdd(01E10D00D").mangledNameHash());
    ASSERT_EQ(0x000005f2u, ImmutableString("imageAtomicAdd(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x000005f3u, ImmutableString("imageAtomicAdd(01a10D00D").mangledNameHash());
    ASSERT_EQ(0x000005f4u, ImmutableString("imageAtomicAdd(01I10D00D").mangledNameHash());
    ASSERT_EQ(0x000005f5u, ImmutableString("imageAtomicAdd(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x000005f6u, ImmutableString("imageAtomicAdd(01e10D00D").mangledNameHash());
    ASSERT_EQ(0x000005f7u, ImmutableString("imageAtomicAdd(01F10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005f8u, ImmutableString("imageAtomicAdd(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005f9u, ImmutableString("imageAtomicAdd(01b10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005fau, ImmutableString("imageAtomicAdd(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005fbu, ImmutableString("imageAtomicAdd(01R20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005fcu, ImmutableString("imageAtomicAdd(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000005fdu, ImmutableString("imageAtomicMin(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000005feu, ImmutableString("imageAtomicMin(01K10D00E").mangledNameHash());
    ASSERT_EQ(0x000005ffu, ImmutableString("imageAtomicMin(01V10D00E").mangledNameHash());
    ASSERT_EQ(0x00000600u, ImmutableString("imageAtomicMin(01A20D00E").mangledNameHash());
    ASSERT_EQ(0x00000601u, ImmutableString("imageAtomicMin(01L20D00E").mangledNameHash());
    ASSERT_EQ(0x00000602u, ImmutableString("imageAtomicMin(01W20D00E").mangledNameHash());
    ASSERT_EQ(0x00000603u, ImmutableString("imageAtomicMin(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000604u, ImmutableString("imageAtomicMin(01N20D00E").mangledNameHash());
    ASSERT_EQ(0x00000605u, ImmutableString("imageAtomicMin(01Y20D00E").mangledNameHash());
    ASSERT_EQ(0x00000606u, ImmutableString("imageAtomicMin(01J00D00E").mangledNameHash());
    ASSERT_EQ(0x00000607u, ImmutableString("imageAtomicMin(01U00D00E").mangledNameHash());
    ASSERT_EQ(0x00000608u, ImmutableString("imageAtomicMin(01f00D00E").mangledNameHash());
    ASSERT_EQ(0x00000609u, ImmutableString("imageAtomicMin(01B20D00E").mangledNameHash());
    ASSERT_EQ(0x0000060au, ImmutableString("imageAtomicMin(01M20D00E").mangledNameHash());
    ASSERT_EQ(0x0000060bu, ImmutableString("imageAtomicMin(01X20D00E").mangledNameHash());
    ASSERT_EQ(0x0000060cu, ImmutableString("imageAtomicMin(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x0000060du, ImmutableString("imageAtomicMin(01S20D00E").mangledNameHash());
    ASSERT_EQ(0x0000060eu, ImmutableString("imageAtomicMin(01d20D00E").mangledNameHash());
    ASSERT_EQ(0x0000060fu, ImmutableString("imageAtomicMin(01D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000610u, ImmutableString("imageAtomicMin(01O00D00E").mangledNameHash());
    ASSERT_EQ(0x00000611u, ImmutableString("imageAtomicMin(01Z00D00E").mangledNameHash());
    ASSERT_EQ(0x00000612u, ImmutableString("imageAtomicMin(01E10D00E").mangledNameHash());
    ASSERT_EQ(0x00000613u, ImmutableString("imageAtomicMin(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000614u, ImmutableString("imageAtomicMin(01a10D00E").mangledNameHash());
    ASSERT_EQ(0x00000615u, ImmutableString("imageAtomicMin(01I10D00E").mangledNameHash());
    ASSERT_EQ(0x00000616u, ImmutableString("imageAtomicMin(01T10D00E").mangledNameHash());
    ASSERT_EQ(0x00000617u, ImmutableString("imageAtomicMin(01e10D00E").mangledNameHash());
    ASSERT_EQ(0x00000618u, ImmutableString("imageAtomicMin(01F10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000619u, ImmutableString("imageAtomicMin(01Q10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000061au, ImmutableString("imageAtomicMin(01b10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000061bu, ImmutableString("imageAtomicMin(01G20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000061cu, ImmutableString("imageAtomicMin(01R20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000061du, ImmutableString("imageAtomicMin(01c20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000061eu, ImmutableString("imageAtomicMin(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x0000061fu, ImmutableString("imageAtomicMin(01K10D00D").mangledNameHash());
    ASSERT_EQ(0x00000620u, ImmutableString("imageAtomicMin(01V10D00D").mangledNameHash());
    ASSERT_EQ(0x00000621u, ImmutableString("imageAtomicMin(01A20D00D").mangledNameHash());
    ASSERT_EQ(0x00000622u, ImmutableString("imageAtomicMin(01L20D00D").mangledNameHash());
    ASSERT_EQ(0x00000623u, ImmutableString("imageAtomicMin(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x00000624u, ImmutableString("imageAtomicMin(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x00000625u, ImmutableString("imageAtomicMin(01N20D00D").mangledNameHash());
    ASSERT_EQ(0x00000626u, ImmutableString("imageAtomicMin(01Y20D00D").mangledNameHash());
    ASSERT_EQ(0x00000627u, ImmutableString("imageAtomicMin(01J00D00D").mangledNameHash());
    ASSERT_EQ(0x00000628u, ImmutableString("imageAtomicMin(01U00D00D").mangledNameHash());
    ASSERT_EQ(0x00000629u, ImmutableString("imageAtomicMin(01f00D00D").mangledNameHash());
    ASSERT_EQ(0x0000062au, ImmutableString("imageAtomicMin(01B20D00D").mangledNameHash());
    ASSERT_EQ(0x0000062bu, ImmutableString("imageAtomicMin(01M20D00D").mangledNameHash());
    ASSERT_EQ(0x0000062cu, ImmutableString("imageAtomicMin(01X20D00D").mangledNameHash());
    ASSERT_EQ(0x0000062du, ImmutableString("imageAtomicMin(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x0000062eu, ImmutableString("imageAtomicMin(01S20D00D").mangledNameHash());
    ASSERT_EQ(0x0000062fu, ImmutableString("imageAtomicMin(01d20D00D").mangledNameHash());
    ASSERT_EQ(0x00000630u, ImmutableString("imageAtomicMin(01D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000631u, ImmutableString("imageAtomicMin(01O00D00D").mangledNameHash());
    ASSERT_EQ(0x00000632u, ImmutableString("imageAtomicMin(01Z00D00D").mangledNameHash());
    ASSERT_EQ(0x00000633u, ImmutableString("imageAtomicMin(01E10D00D").mangledNameHash());
    ASSERT_EQ(0x00000634u, ImmutableString("imageAtomicMin(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000635u, ImmutableString("imageAtomicMin(01a10D00D").mangledNameHash());
    ASSERT_EQ(0x00000636u, ImmutableString("imageAtomicMin(01I10D00D").mangledNameHash());
    ASSERT_EQ(0x00000637u, ImmutableString("imageAtomicMin(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x00000638u, ImmutableString("imageAtomicMin(01e10D00D").mangledNameHash());
    ASSERT_EQ(0x00000639u, ImmutableString("imageAtomicMin(01F10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000063au, ImmutableString("imageAtomicMin(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000063bu, ImmutableString("imageAtomicMin(01b10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000063cu, ImmutableString("imageAtomicMin(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000063du, ImmutableString("imageAtomicMin(01R20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000063eu, ImmutableString("imageAtomicMin(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000063fu, ImmutableString("imageAtomicMax(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000640u, ImmutableString("imageAtomicMax(01K10D00E").mangledNameHash());
    ASSERT_EQ(0x00000641u, ImmutableString("imageAtomicMax(01V10D00E").mangledNameHash());
    ASSERT_EQ(0x00000642u, ImmutableString("imageAtomicMax(01A20D00E").mangledNameHash());
    ASSERT_EQ(0x00000643u, ImmutableString("imageAtomicMax(01L20D00E").mangledNameHash());
    ASSERT_EQ(0x00000644u, ImmutableString("imageAtomicMax(01W20D00E").mangledNameHash());
    ASSERT_EQ(0x00000645u, ImmutableString("imageAtomicMax(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000646u, ImmutableString("imageAtomicMax(01N20D00E").mangledNameHash());
    ASSERT_EQ(0x00000647u, ImmutableString("imageAtomicMax(01Y20D00E").mangledNameHash());
    ASSERT_EQ(0x00000648u, ImmutableString("imageAtomicMax(01J00D00E").mangledNameHash());
    ASSERT_EQ(0x00000649u, ImmutableString("imageAtomicMax(01U00D00E").mangledNameHash());
    ASSERT_EQ(0x0000064au, ImmutableString("imageAtomicMax(01f00D00E").mangledNameHash());
    ASSERT_EQ(0x0000064bu, ImmutableString("imageAtomicMax(01B20D00E").mangledNameHash());
    ASSERT_EQ(0x0000064cu, ImmutableString("imageAtomicMax(01M20D00E").mangledNameHash());
    ASSERT_EQ(0x0000064du, ImmutableString("imageAtomicMax(01X20D00E").mangledNameHash());
    ASSERT_EQ(0x0000064eu, ImmutableString("imageAtomicMax(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x0000064fu, ImmutableString("imageAtomicMax(01S20D00E").mangledNameHash());
    ASSERT_EQ(0x00000650u, ImmutableString("imageAtomicMax(01d20D00E").mangledNameHash());
    ASSERT_EQ(0x00000651u, ImmutableString("imageAtomicMax(01D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000652u, ImmutableString("imageAtomicMax(01O00D00E").mangledNameHash());
    ASSERT_EQ(0x00000653u, ImmutableString("imageAtomicMax(01Z00D00E").mangledNameHash());
    ASSERT_EQ(0x00000654u, ImmutableString("imageAtomicMax(01E10D00E").mangledNameHash());
    ASSERT_EQ(0x00000655u, ImmutableString("imageAtomicMax(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000656u, ImmutableString("imageAtomicMax(01a10D00E").mangledNameHash());
    ASSERT_EQ(0x00000657u, ImmutableString("imageAtomicMax(01I10D00E").mangledNameHash());
    ASSERT_EQ(0x00000658u, ImmutableString("imageAtomicMax(01T10D00E").mangledNameHash());
    ASSERT_EQ(0x00000659u, ImmutableString("imageAtomicMax(01e10D00E").mangledNameHash());
    ASSERT_EQ(0x0000065au, ImmutableString("imageAtomicMax(01F10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000065bu, ImmutableString("imageAtomicMax(01Q10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000065cu, ImmutableString("imageAtomicMax(01b10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000065du, ImmutableString("imageAtomicMax(01G20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000065eu, ImmutableString("imageAtomicMax(01R20D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000065fu, ImmutableString("imageAtomicMax(01c20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000660u, ImmutableString("imageAtomicMax(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000661u, ImmutableString("imageAtomicMax(01K10D00D").mangledNameHash());
    ASSERT_EQ(0x00000662u, ImmutableString("imageAtomicMax(01V10D00D").mangledNameHash());
    ASSERT_EQ(0x00000663u, ImmutableString("imageAtomicMax(01A20D00D").mangledNameHash());
    ASSERT_EQ(0x00000664u, ImmutableString("imageAtomicMax(01L20D00D").mangledNameHash());
    ASSERT_EQ(0x00000665u, ImmutableString("imageAtomicMax(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x00000666u, ImmutableString("imageAtomicMax(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x00000667u, ImmutableString("imageAtomicMax(01N20D00D").mangledNameHash());
    ASSERT_EQ(0x00000668u, ImmutableString("imageAtomicMax(01Y20D00D").mangledNameHash());
    ASSERT_EQ(0x00000669u, ImmutableString("imageAtomicMax(01J00D00D").mangledNameHash());
    ASSERT_EQ(0x0000066au, ImmutableString("imageAtomicMax(01U00D00D").mangledNameHash());
    ASSERT_EQ(0x0000066bu, ImmutableString("imageAtomicMax(01f00D00D").mangledNameHash());
    ASSERT_EQ(0x0000066cu, ImmutableString("imageAtomicMax(01B20D00D").mangledNameHash());
    ASSERT_EQ(0x0000066du, ImmutableString("imageAtomicMax(01M20D00D").mangledNameHash());
    ASSERT_EQ(0x0000066eu, ImmutableString("imageAtomicMax(01X20D00D").mangledNameHash());
    ASSERT_EQ(0x0000066fu, ImmutableString("imageAtomicMax(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x00000670u, ImmutableString("imageAtomicMax(01S20D00D").mangledNameHash());
    ASSERT_EQ(0x00000671u, ImmutableString("imageAtomicMax(01d20D00D").mangledNameHash());
    ASSERT_EQ(0x00000672u, ImmutableString("imageAtomicMax(01D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000673u, ImmutableString("imageAtomicMax(01O00D00D").mangledNameHash());
    ASSERT_EQ(0x00000674u, ImmutableString("imageAtomicMax(01Z00D00D").mangledNameHash());
    ASSERT_EQ(0x00000675u, ImmutableString("imageAtomicMax(01E10D00D").mangledNameHash());
    ASSERT_EQ(0x00000676u, ImmutableString("imageAtomicMax(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000677u, ImmutableString("imageAtomicMax(01a10D00D").mangledNameHash());
    ASSERT_EQ(0x00000678u, ImmutableString("imageAtomicMax(01I10D00D").mangledNameHash());
    ASSERT_EQ(0x00000679u, ImmutableString("imageAtomicMax(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x0000067au, ImmutableString("imageAtomicMax(01e10D00D").mangledNameHash());
    ASSERT_EQ(0x0000067bu, ImmutableString("imageAtomicMax(01F10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000067cu, ImmutableString("imageAtomicMax(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000067du, ImmutableString("imageAtomicMax(01b10D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000067eu, ImmutableString("imageAtomicMax(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000067fu, ImmutableString("imageAtomicMax(01R20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000680u, ImmutableString("imageAtomicMax(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000681u, ImmutableString("imageAtomicAnd(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000682u, ImmutableString("imageAtomicAnd(01K10D00E").mangledNameHash());
    ASSERT_EQ(0x00000683u, ImmutableString("imageAtomicAnd(01V10D00E").mangledNameHash());
    ASSERT_EQ(0x00000684u, ImmutableString("imageAtomicAnd(01A20D00E").mangledNameHash());
    ASSERT_EQ(0x00000685u, ImmutableString("imageAtomicAnd(01L20D00E").mangledNameHash());
    ASSERT_EQ(0x00000686u, ImmutableString("imageAtomicAnd(01W20D00E").mangledNameHash());
    ASSERT_EQ(0x00000687u, ImmutableString("imageAtomicAnd(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x00000688u, ImmutableString("imageAtomicAnd(01N20D00E").mangledNameHash());
    ASSERT_EQ(0x00000689u, ImmutableString("imageAtomicAnd(01Y20D00E").mangledNameHash());
    ASSERT_EQ(0x0000068au, ImmutableString("imageAtomicAnd(01J00D00E").mangledNameHash());
    ASSERT_EQ(0x0000068bu, ImmutableString("imageAtomicAnd(01U00D00E").mangledNameHash());
    ASSERT_EQ(0x0000068cu, ImmutableString("imageAtomicAnd(01f00D00E").mangledNameHash());
    ASSERT_EQ(0x0000068du, ImmutableString("imageAtomicAnd(01B20D00E").mangledNameHash());
    ASSERT_EQ(0x0000068eu, ImmutableString("imageAtomicAnd(01M20D00E").mangledNameHash());
    ASSERT_EQ(0x0000068fu, ImmutableString("imageAtomicAnd(01X20D00E").mangledNameHash());
    ASSERT_EQ(0x00000690u, ImmutableString("imageAtomicAnd(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x00000691u, ImmutableString("imageAtomicAnd(01S20D00E").mangledNameHash());
    ASSERT_EQ(0x00000692u, ImmutableString("imageAtomicAnd(01d20D00E").mangledNameHash());
    ASSERT_EQ(0x00000693u, ImmutableString("imageAtomicAnd(01D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000694u, ImmutableString("imageAtomicAnd(01O00D00E").mangledNameHash());
    ASSERT_EQ(0x00000695u, ImmutableString("imageAtomicAnd(01Z00D00E").mangledNameHash());
    ASSERT_EQ(0x00000696u, ImmutableString("imageAtomicAnd(01E10D00E").mangledNameHash());
    ASSERT_EQ(0x00000697u, ImmutableString("imageAtomicAnd(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x00000698u, ImmutableString("imageAtomicAnd(01a10D00E").mangledNameHash());
    ASSERT_EQ(0x00000699u, ImmutableString("imageAtomicAnd(01I10D00E").mangledNameHash());
    ASSERT_EQ(0x0000069au, ImmutableString("imageAtomicAnd(01T10D00E").mangledNameHash());
    ASSERT_EQ(0x0000069bu, ImmutableString("imageAtomicAnd(01e10D00E").mangledNameHash());
    ASSERT_EQ(0x0000069cu, ImmutableString("imageAtomicAnd(01F10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000069du, ImmutableString("imageAtomicAnd(01Q10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000069eu, ImmutableString("imageAtomicAnd(01b10D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000069fu, ImmutableString("imageAtomicAnd(01G20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006a0u, ImmutableString("imageAtomicAnd(01R20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006a1u, ImmutableString("imageAtomicAnd(01c20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006a2u, ImmutableString("imageAtomicAnd(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x000006a3u, ImmutableString("imageAtomicAnd(01K10D00D").mangledNameHash());
    ASSERT_EQ(0x000006a4u, ImmutableString("imageAtomicAnd(01V10D00D").mangledNameHash());
    ASSERT_EQ(0x000006a5u, ImmutableString("imageAtomicAnd(01A20D00D").mangledNameHash());
    ASSERT_EQ(0x000006a6u, ImmutableString("imageAtomicAnd(01L20D00D").mangledNameHash());
    ASSERT_EQ(0x000006a7u, ImmutableString("imageAtomicAnd(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x000006a8u, ImmutableString("imageAtomicAnd(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000006a9u, ImmutableString("imageAtomicAnd(01N20D00D").mangledNameHash());
    ASSERT_EQ(0x000006aau, ImmutableString("imageAtomicAnd(01Y20D00D").mangledNameHash());
    ASSERT_EQ(0x000006abu, ImmutableString("imageAtomicAnd(01J00D00D").mangledNameHash());
    ASSERT_EQ(0x000006acu, ImmutableString("imageAtomicAnd(01U00D00D").mangledNameHash());
    ASSERT_EQ(0x000006adu, ImmutableString("imageAtomicAnd(01f00D00D").mangledNameHash());
    ASSERT_EQ(0x000006aeu, ImmutableString("imageAtomicAnd(01B20D00D").mangledNameHash());
    ASSERT_EQ(0x000006afu, ImmutableString("imageAtomicAnd(01M20D00D").mangledNameHash());
    ASSERT_EQ(0x000006b0u, ImmutableString("imageAtomicAnd(01X20D00D").mangledNameHash());
    ASSERT_EQ(0x000006b1u, ImmutableString("imageAtomicAnd(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000006b2u, ImmutableString("imageAtomicAnd(01S20D00D").mangledNameHash());
    ASSERT_EQ(0x000006b3u, ImmutableString("imageAtomicAnd(01d20D00D").mangledNameHash());
    ASSERT_EQ(0x000006b4u, ImmutableString("imageAtomicAnd(01D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006b5u, ImmutableString("imageAtomicAnd(01O00D00D").mangledNameHash());
    ASSERT_EQ(0x000006b6u, ImmutableString("imageAtomicAnd(01Z00D00D").mangledNameHash());
    ASSERT_EQ(0x000006b7u, ImmutableString("imageAtomicAnd(01E10D00D").mangledNameHash());
    ASSERT_EQ(0x000006b8u, ImmutableString("imageAtomicAnd(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x000006b9u, ImmutableString("imageAtomicAnd(01a10D00D").mangledNameHash());
    ASSERT_EQ(0x000006bau, ImmutableString("imageAtomicAnd(01I10D00D").mangledNameHash());
    ASSERT_EQ(0x000006bbu, ImmutableString("imageAtomicAnd(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x000006bcu, ImmutableString("imageAtomicAnd(01e10D00D").mangledNameHash());
    ASSERT_EQ(0x000006bdu, ImmutableString("imageAtomicAnd(01F10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006beu, ImmutableString("imageAtomicAnd(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006bfu, ImmutableString("imageAtomicAnd(01b10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006c0u, ImmutableString("imageAtomicAnd(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006c1u, ImmutableString("imageAtomicAnd(01R20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006c2u, ImmutableString("imageAtomicAnd(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006c3u, ImmutableString("imageAtomicOr(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x000006c4u, ImmutableString("imageAtomicOr(01K10D00E").mangledNameHash());
    ASSERT_EQ(0x000006c5u, ImmutableString("imageAtomicOr(01V10D00E").mangledNameHash());
    ASSERT_EQ(0x000006c6u, ImmutableString("imageAtomicOr(01A20D00E").mangledNameHash());
    ASSERT_EQ(0x000006c7u, ImmutableString("imageAtomicOr(01L20D00E").mangledNameHash());
    ASSERT_EQ(0x000006c8u, ImmutableString("imageAtomicOr(01W20D00E").mangledNameHash());
    ASSERT_EQ(0x000006c9u, ImmutableString("imageAtomicOr(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x000006cau, ImmutableString("imageAtomicOr(01N20D00E").mangledNameHash());
    ASSERT_EQ(0x000006cbu, ImmutableString("imageAtomicOr(01Y20D00E").mangledNameHash());
    ASSERT_EQ(0x000006ccu, ImmutableString("imageAtomicOr(01J00D00E").mangledNameHash());
    ASSERT_EQ(0x000006cdu, ImmutableString("imageAtomicOr(01U00D00E").mangledNameHash());
    ASSERT_EQ(0x000006ceu, ImmutableString("imageAtomicOr(01f00D00E").mangledNameHash());
    ASSERT_EQ(0x000006cfu, ImmutableString("imageAtomicOr(01B20D00E").mangledNameHash());
    ASSERT_EQ(0x000006d0u, ImmutableString("imageAtomicOr(01M20D00E").mangledNameHash());
    ASSERT_EQ(0x000006d1u, ImmutableString("imageAtomicOr(01X20D00E").mangledNameHash());
    ASSERT_EQ(0x000006d2u, ImmutableString("imageAtomicOr(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x000006d3u, ImmutableString("imageAtomicOr(01S20D00E").mangledNameHash());
    ASSERT_EQ(0x000006d4u, ImmutableString("imageAtomicOr(01d20D00E").mangledNameHash());
    ASSERT_EQ(0x000006d5u, ImmutableString("imageAtomicOr(01D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006d6u, ImmutableString("imageAtomicOr(01O00D00E").mangledNameHash());
    ASSERT_EQ(0x000006d7u, ImmutableString("imageAtomicOr(01Z00D00E").mangledNameHash());
    ASSERT_EQ(0x000006d8u, ImmutableString("imageAtomicOr(01E10D00E").mangledNameHash());
    ASSERT_EQ(0x000006d9u, ImmutableString("imageAtomicOr(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x000006dau, ImmutableString("imageAtomicOr(01a10D00E").mangledNameHash());
    ASSERT_EQ(0x000006dbu, ImmutableString("imageAtomicOr(01I10D00E").mangledNameHash());
    ASSERT_EQ(0x000006dcu, ImmutableString("imageAtomicOr(01T10D00E").mangledNameHash());
    ASSERT_EQ(0x000006ddu, ImmutableString("imageAtomicOr(01e10D00E").mangledNameHash());
    ASSERT_EQ(0x000006deu, ImmutableString("imageAtomicOr(01F10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006dfu, ImmutableString("imageAtomicOr(01Q10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006e0u, ImmutableString("imageAtomicOr(01b10D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006e1u, ImmutableString("imageAtomicOr(01G20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006e2u, ImmutableString("imageAtomicOr(01R20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006e3u, ImmutableString("imageAtomicOr(01c20D00D00E").mangledNameHash());
    ASSERT_EQ(0x000006e4u, ImmutableString("imageAtomicOr(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x000006e5u, ImmutableString("imageAtomicOr(01K10D00D").mangledNameHash());
    ASSERT_EQ(0x000006e6u, ImmutableString("imageAtomicOr(01V10D00D").mangledNameHash());
    ASSERT_EQ(0x000006e7u, ImmutableString("imageAtomicOr(01A20D00D").mangledNameHash());
    ASSERT_EQ(0x000006e8u, ImmutableString("imageAtomicOr(01L20D00D").mangledNameHash());
    ASSERT_EQ(0x000006e9u, ImmutableString("imageAtomicOr(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x000006eau, ImmutableString("imageAtomicOr(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x000006ebu, ImmutableString("imageAtomicOr(01N20D00D").mangledNameHash());
    ASSERT_EQ(0x000006ecu, ImmutableString("imageAtomicOr(01Y20D00D").mangledNameHash());
    ASSERT_EQ(0x000006edu, ImmutableString("imageAtomicOr(01J00D00D").mangledNameHash());
    ASSERT_EQ(0x000006eeu, ImmutableString("imageAtomicOr(01U00D00D").mangledNameHash());
    ASSERT_EQ(0x000006efu, ImmutableString("imageAtomicOr(01f00D00D").mangledNameHash());
    ASSERT_EQ(0x000006f0u, ImmutableString("imageAtomicOr(01B20D00D").mangledNameHash());
    ASSERT_EQ(0x000006f1u, ImmutableString("imageAtomicOr(01M20D00D").mangledNameHash());
    ASSERT_EQ(0x000006f2u, ImmutableString("imageAtomicOr(01X20D00D").mangledNameHash());
    ASSERT_EQ(0x000006f3u, ImmutableString("imageAtomicOr(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x000006f4u, ImmutableString("imageAtomicOr(01S20D00D").mangledNameHash());
    ASSERT_EQ(0x000006f5u, ImmutableString("imageAtomicOr(01d20D00D").mangledNameHash());
    ASSERT_EQ(0x000006f6u, ImmutableString("imageAtomicOr(01D00D00D").mangledNameHash());
    ASSERT_EQ(0x000006f7u, ImmutableString("imageAtomicOr(01O00D00D").mangledNameHash());
    ASSERT_EQ(0x000006f8u, ImmutableString("imageAtomicOr(01Z00D00D").mangledNameHash());
    ASSERT_EQ(0x000006f9u, ImmutableString("imageAtomicOr(01E10D00D").mangledNameHash());
    ASSERT_EQ(0x000006fau, ImmutableString("imageAtomicOr(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x000006fbu, ImmutableString("imageAtomicOr(01a10D00D").mangledNameHash());
    ASSERT_EQ(0x000006fcu, ImmutableString("imageAtomicOr(01I10D00D").mangledNameHash());
    ASSERT_EQ(0x000006fdu, ImmutableString("imageAtomicOr(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x000006feu, ImmutableString("imageAtomicOr(01e10D00D").mangledNameHash());
    ASSERT_EQ(0x000006ffu, ImmutableString("imageAtomicOr(01F10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000700u, ImmutableString("imageAtomicOr(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000701u, ImmutableString("imageAtomicOr(01b10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000702u, ImmutableString("imageAtomicOr(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000703u, ImmutableString("imageAtomicOr(01R20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000704u, ImmutableString("imageAtomicOr(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000705u, ImmutableString("imageAtomicXor(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000706u, ImmutableString("imageAtomicXor(01K10D00E").mangledNameHash());
    ASSERT_EQ(0x00000707u, ImmutableString("imageAtomicXor(01V10D00E").mangledNameHash());
    ASSERT_EQ(0x00000708u, ImmutableString("imageAtomicXor(01A20D00E").mangledNameHash());
    ASSERT_EQ(0x00000709u, ImmutableString("imageAtomicXor(01L20D00E").mangledNameHash());
    ASSERT_EQ(0x0000070au, ImmutableString("imageAtomicXor(01W20D00E").mangledNameHash());
    ASSERT_EQ(0x0000070bu, ImmutableString("imageAtomicXor(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x0000070cu, ImmutableString("imageAtomicXor(01N20D00E").mangledNameHash());
    ASSERT_EQ(0x0000070du, ImmutableString("imageAtomicXor(01Y20D00E").mangledNameHash());
    ASSERT_EQ(0x0000070eu, ImmutableString("imageAtomicXor(01J00D00E").mangledNameHash());
    ASSERT_EQ(0x0000070fu, ImmutableString("imageAtomicXor(01U00D00E").mangledNameHash());
    ASSERT_EQ(0x00000710u, ImmutableString("imageAtomicXor(01f00D00E").mangledNameHash());
    ASSERT_EQ(0x00000711u, ImmutableString("imageAtomicXor(01B20D00E").mangledNameHash());
    ASSERT_EQ(0x00000712u, ImmutableString("imageAtomicXor(01M20D00E").mangledNameHash());
    ASSERT_EQ(0x00000713u, ImmutableString("imageAtomicXor(01X20D00E").mangledNameHash());
    ASSERT_EQ(0x00000714u, ImmutableString("imageAtomicXor(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x00000715u, ImmutableString("imageAtomicXor(01S20D00E").mangledNameHash());
    ASSERT_EQ(0x00000716u, ImmutableString("imageAtomicXor(01d20D00E").mangledNameHash());
    ASSERT_EQ(0x00000717u, ImmutableString("imageAtomicXor(01D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000718u, ImmutableString("imageAtomicXor(01O00D00E").mangledNameHash());
    ASSERT_EQ(0x00000719u, ImmutableString("imageAtomicXor(01Z00D00E").mangledNameHash());
    ASSERT_EQ(0x0000071au, ImmutableString("imageAtomicXor(01E10D00E").mangledNameHash());
    ASSERT_EQ(0x0000071bu, ImmutableString("imageAtomicXor(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x0000071cu, ImmutableString("imageAtomicXor(01a10D00E").mangledNameHash());
    ASSERT_EQ(0x0000071du, ImmutableString("imageAtomicXor(01I10D00E").mangledNameHash());
    ASSERT_EQ(0x0000071eu, ImmutableString("imageAtomicXor(01T10D00E").mangledNameHash());
    ASSERT_EQ(0x0000071fu, ImmutableString("imageAtomicXor(01e10D00E").mangledNameHash());
    ASSERT_EQ(0x00000720u, ImmutableString("imageAtomicXor(01F10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000721u, ImmutableString("imageAtomicXor(01Q10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000722u, ImmutableString("imageAtomicXor(01b10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000723u, ImmutableString("imageAtomicXor(01G20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000724u, ImmutableString("imageAtomicXor(01R20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000725u, ImmutableString("imageAtomicXor(01c20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000726u, ImmutableString("imageAtomicXor(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000727u, ImmutableString("imageAtomicXor(01K10D00D").mangledNameHash());
    ASSERT_EQ(0x00000728u, ImmutableString("imageAtomicXor(01V10D00D").mangledNameHash());
    ASSERT_EQ(0x00000729u, ImmutableString("imageAtomicXor(01A20D00D").mangledNameHash());
    ASSERT_EQ(0x0000072au, ImmutableString("imageAtomicXor(01L20D00D").mangledNameHash());
    ASSERT_EQ(0x0000072bu, ImmutableString("imageAtomicXor(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x0000072cu, ImmutableString("imageAtomicXor(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x0000072du, ImmutableString("imageAtomicXor(01N20D00D").mangledNameHash());
    ASSERT_EQ(0x0000072eu, ImmutableString("imageAtomicXor(01Y20D00D").mangledNameHash());
    ASSERT_EQ(0x0000072fu, ImmutableString("imageAtomicXor(01J00D00D").mangledNameHash());
    ASSERT_EQ(0x00000730u, ImmutableString("imageAtomicXor(01U00D00D").mangledNameHash());
    ASSERT_EQ(0x00000731u, ImmutableString("imageAtomicXor(01f00D00D").mangledNameHash());
    ASSERT_EQ(0x00000732u, ImmutableString("imageAtomicXor(01B20D00D").mangledNameHash());
    ASSERT_EQ(0x00000733u, ImmutableString("imageAtomicXor(01M20D00D").mangledNameHash());
    ASSERT_EQ(0x00000734u, ImmutableString("imageAtomicXor(01X20D00D").mangledNameHash());
    ASSERT_EQ(0x00000735u, ImmutableString("imageAtomicXor(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x00000736u, ImmutableString("imageAtomicXor(01S20D00D").mangledNameHash());
    ASSERT_EQ(0x00000737u, ImmutableString("imageAtomicXor(01d20D00D").mangledNameHash());
    ASSERT_EQ(0x00000738u, ImmutableString("imageAtomicXor(01D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000739u, ImmutableString("imageAtomicXor(01O00D00D").mangledNameHash());
    ASSERT_EQ(0x0000073au, ImmutableString("imageAtomicXor(01Z00D00D").mangledNameHash());
    ASSERT_EQ(0x0000073bu, ImmutableString("imageAtomicXor(01E10D00D").mangledNameHash());
    ASSERT_EQ(0x0000073cu, ImmutableString("imageAtomicXor(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000073du, ImmutableString("imageAtomicXor(01a10D00D").mangledNameHash());
    ASSERT_EQ(0x0000073eu, ImmutableString("imageAtomicXor(01I10D00D").mangledNameHash());
    ASSERT_EQ(0x0000073fu, ImmutableString("imageAtomicXor(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x00000740u, ImmutableString("imageAtomicXor(01e10D00D").mangledNameHash());
    ASSERT_EQ(0x00000741u, ImmutableString("imageAtomicXor(01F10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000742u, ImmutableString("imageAtomicXor(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000743u, ImmutableString("imageAtomicXor(01b10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000744u, ImmutableString("imageAtomicXor(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000745u, ImmutableString("imageAtomicXor(01R20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000746u, ImmutableString("imageAtomicXor(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000747u, ImmutableString("imageAtomicExchange(00z10D00E").mangledNameHash());
    ASSERT_EQ(0x00000748u, ImmutableString("imageAtomicExchange(01K10D00E").mangledNameHash());
    ASSERT_EQ(0x00000749u, ImmutableString("imageAtomicExchange(01V10D00E").mangledNameHash());
    ASSERT_EQ(0x0000074au, ImmutableString("imageAtomicExchange(01A20D00E").mangledNameHash());
    ASSERT_EQ(0x0000074bu, ImmutableString("imageAtomicExchange(01L20D00E").mangledNameHash());
    ASSERT_EQ(0x0000074cu, ImmutableString("imageAtomicExchange(01W20D00E").mangledNameHash());
    ASSERT_EQ(0x0000074du, ImmutableString("imageAtomicExchange(01C20D00E").mangledNameHash());
    ASSERT_EQ(0x0000074eu, ImmutableString("imageAtomicExchange(01N20D00E").mangledNameHash());
    ASSERT_EQ(0x0000074fu, ImmutableString("imageAtomicExchange(01Y20D00E").mangledNameHash());
    ASSERT_EQ(0x00000750u, ImmutableString("imageAtomicExchange(01J00D00E").mangledNameHash());
    ASSERT_EQ(0x00000751u, ImmutableString("imageAtomicExchange(01U00D00E").mangledNameHash());
    ASSERT_EQ(0x00000752u, ImmutableString("imageAtomicExchange(01f00D00E").mangledNameHash());
    ASSERT_EQ(0x00000753u, ImmutableString("imageAtomicExchange(01B20D00E").mangledNameHash());
    ASSERT_EQ(0x00000754u, ImmutableString("imageAtomicExchange(01M20D00E").mangledNameHash());
    ASSERT_EQ(0x00000755u, ImmutableString("imageAtomicExchange(01X20D00E").mangledNameHash());
    ASSERT_EQ(0x00000756u, ImmutableString("imageAtomicExchange(01H20D00E").mangledNameHash());
    ASSERT_EQ(0x00000757u, ImmutableString("imageAtomicExchange(01S20D00E").mangledNameHash());
    ASSERT_EQ(0x00000758u, ImmutableString("imageAtomicExchange(01d20D00E").mangledNameHash());
    ASSERT_EQ(0x00000759u, ImmutableString("imageAtomicExchange(01D00D00E").mangledNameHash());
    ASSERT_EQ(0x0000075au, ImmutableString("imageAtomicExchange(01O00D00E").mangledNameHash());
    ASSERT_EQ(0x0000075bu, ImmutableString("imageAtomicExchange(01Z00D00E").mangledNameHash());
    ASSERT_EQ(0x0000075cu, ImmutableString("imageAtomicExchange(01E10D00E").mangledNameHash());
    ASSERT_EQ(0x0000075du, ImmutableString("imageAtomicExchange(01P10D00E").mangledNameHash());
    ASSERT_EQ(0x0000075eu, ImmutableString("imageAtomicExchange(01a10D00E").mangledNameHash());
    ASSERT_EQ(0x0000075fu, ImmutableString("imageAtomicExchange(01I10D00E").mangledNameHash());
    ASSERT_EQ(0x00000760u, ImmutableString("imageAtomicExchange(01T10D00E").mangledNameHash());
    ASSERT_EQ(0x00000761u, ImmutableString("imageAtomicExchange(01e10D00E").mangledNameHash());
    ASSERT_EQ(0x00000762u, ImmutableString("imageAtomicExchange(01F10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000763u, ImmutableString("imageAtomicExchange(01Q10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000764u, ImmutableString("imageAtomicExchange(01b10D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000765u, ImmutableString("imageAtomicExchange(01G20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000766u, ImmutableString("imageAtomicExchange(01R20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000767u, ImmutableString("imageAtomicExchange(01c20D00D00E").mangledNameHash());
    ASSERT_EQ(0x00000768u, ImmutableString("imageAtomicExchange(00z10D00D").mangledNameHash());
    ASSERT_EQ(0x00000769u, ImmutableString("imageAtomicExchange(01K10D00D").mangledNameHash());
    ASSERT_EQ(0x0000076au, ImmutableString("imageAtomicExchange(01V10D00D").mangledNameHash());
    ASSERT_EQ(0x0000076bu, ImmutableString("imageAtomicExchange(01A20D00D").mangledNameHash());
    ASSERT_EQ(0x0000076cu, ImmutableString("imageAtomicExchange(01L20D00D").mangledNameHash());
    ASSERT_EQ(0x0000076du, ImmutableString("imageAtomicExchange(01W20D00D").mangledNameHash());
    ASSERT_EQ(0x0000076eu, ImmutableString("imageAtomicExchange(01C20D00D").mangledNameHash());
    ASSERT_EQ(0x0000076fu, ImmutableString("imageAtomicExchange(01N20D00D").mangledNameHash());
    ASSERT_EQ(0x00000770u, ImmutableString("imageAtomicExchange(01Y20D00D").mangledNameHash());
    ASSERT_EQ(0x00000771u, ImmutableString("imageAtomicExchange(01J00D00D").mangledNameHash());
    ASSERT_EQ(0x00000772u, ImmutableString("imageAtomicExchange(01U00D00D").mangledNameHash());
    ASSERT_EQ(0x00000773u, ImmutableString("imageAtomicExchange(01f00D00D").mangledNameHash());
    ASSERT_EQ(0x00000774u, ImmutableString("imageAtomicExchange(01B20D00D").mangledNameHash());
    ASSERT_EQ(0x00000775u, ImmutableString("imageAtomicExchange(01M20D00D").mangledNameHash());
    ASSERT_EQ(0x00000776u, ImmutableString("imageAtomicExchange(01X20D00D").mangledNameHash());
    ASSERT_EQ(0x00000777u, ImmutableString("imageAtomicExchange(01H20D00D").mangledNameHash());
    ASSERT_EQ(0x00000778u, ImmutableString("imageAtomicExchange(01S20D00D").mangledNameHash());
    ASSERT_EQ(0x00000779u, ImmutableString("imageAtomicExchange(01d20D00D").mangledNameHash());
    ASSERT_EQ(0x0000077au, ImmutableString("imageAtomicExchange(01D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000077bu, ImmutableString("imageAtomicExchange(01O00D00D").mangledNameHash());
    ASSERT_EQ(0x0000077cu, ImmutableString("imageAtomicExchange(01Z00D00D").mangledNameHash());
    ASSERT_EQ(0x0000077du, ImmutableString("imageAtomicExchange(01E10D00D").mangledNameHash());
    ASSERT_EQ(0x0000077eu, ImmutableString("imageAtomicExchange(01P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000077fu, ImmutableString("imageAtomicExchange(01a10D00D").mangledNameHash());
    ASSERT_EQ(0x00000780u, ImmutableString("imageAtomicExchange(01I10D00D").mangledNameHash());
    ASSERT_EQ(0x00000781u, ImmutableString("imageAtomicExchange(01T10D00D").mangledNameHash());
    ASSERT_EQ(0x00000782u, ImmutableString("imageAtomicExchange(01e10D00D").mangledNameHash());
    ASSERT_EQ(0x00000783u, ImmutableString("imageAtomicExchange(01F10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000784u, ImmutableString("imageAtomicExchange(01Q10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000785u, ImmutableString("imageAtomicExchange(01b10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000786u, ImmutableString("imageAtomicExchange(01G20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000787u, ImmutableString("imageAtomicExchange(01R20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000788u, ImmutableString("imageAtomicExchange(01c20D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000789u, ImmutableString("imageAtomicExchange(00z10D00B").mangledNameHash());
    ASSERT_EQ(0x0000078au, ImmutableString("imageAtomicExchange(01K10D00B").mangledNameHash());
    ASSERT_EQ(0x0000078bu, ImmutableString("imageAtomicExchange(01V10D00B").mangledNameHash());
    ASSERT_EQ(0x0000078cu, ImmutableString("imageAtomicExchange(01A20D00B").mangledNameHash());
    ASSERT_EQ(0x0000078du, ImmutableString("imageAtomicExchange(01L20D00B").mangledNameHash());
    ASSERT_EQ(0x0000078eu, ImmutableString("imageAtomicExchange(01W20D00B").mangledNameHash());
    ASSERT_EQ(0x0000078fu, ImmutableString("imageAtomicExchange(01C20D00B").mangledNameHash());
    ASSERT_EQ(0x00000790u, ImmutableString("imageAtomicExchange(01N20D00B").mangledNameHash());
    ASSERT_EQ(0x00000791u, ImmutableString("imageAtomicExchange(01Y20D00B").mangledNameHash());
    ASSERT_EQ(0x00000792u, ImmutableString("imageAtomicExchange(01J00D00B").mangledNameHash());
    ASSERT_EQ(0x00000793u, ImmutableString("imageAtomicExchange(01U00D00B").mangledNameHash());
    ASSERT_EQ(0x00000794u, ImmutableString("imageAtomicExchange(01f00D00B").mangledNameHash());
    ASSERT_EQ(0x00000795u, ImmutableString("imageAtomicExchange(01B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000796u, ImmutableString("imageAtomicExchange(01M20D00B").mangledNameHash());
    ASSERT_EQ(0x00000797u, ImmutableString("imageAtomicExchange(01X20D00B").mangledNameHash());
    ASSERT_EQ(0x00000798u, ImmutableString("imageAtomicExchange(01H20D00B").mangledNameHash());
    ASSERT_EQ(0x00000799u, ImmutableString("imageAtomicExchange(01S20D00B").mangledNameHash());
    ASSERT_EQ(0x0000079au, ImmutableString("imageAtomicExchange(01d20D00B").mangledNameHash());
    ASSERT_EQ(0x0000079bu, ImmutableString("imageAtomicExchange(01D00D00B").mangledNameHash());
    ASSERT_EQ(0x0000079cu, ImmutableString("imageAtomicExchange(01O00D00B").mangledNameHash());
    ASSERT_EQ(0x0000079du, ImmutableString("imageAtomicExchange(01Z00D00B").mangledNameHash());
    ASSERT_EQ(0x0000079eu, ImmutableString("imageAtomicExchange(01E10D00B").mangledNameHash());
    ASSERT_EQ(0x0000079fu, ImmutableString("imageAtomicExchange(01P10D00B").mangledNameHash());
    ASSERT_EQ(0x000007a0u, ImmutableString("imageAtomicExchange(01a10D00B").mangledNameHash());
    ASSERT_EQ(0x000007a1u, ImmutableString("imageAtomicExchange(01I10D00B").mangledNameHash());
    ASSERT_EQ(0x000007a2u, ImmutableString("imageAtomicExchange(01T10D00B").mangledNameHash());
    ASSERT_EQ(0x000007a3u, ImmutableString("imageAtomicExchange(01e10D00B").mangledNameHash());
    ASSERT_EQ(0x000007a4u, ImmutableString("imageAtomicExchange(01F10D00D00B").mangledNameHash());
    ASSERT_EQ(0x000007a5u, ImmutableString("imageAtomicExchange(01Q10D00D00B").mangledNameHash());
    ASSERT_EQ(0x000007a6u, ImmutableString("imageAtomicExchange(01b10D00D00B").mangledNameHash());
    ASSERT_EQ(0x000007a7u, ImmutableString("imageAtomicExchange(01G20D00D00B").mangledNameHash());
    ASSERT_EQ(0x000007a8u, ImmutableString("imageAtomicExchange(01R20D00D00B").mangledNameHash());
    ASSERT_EQ(0x000007a9u, ImmutableString("imageAtomicExchange(01c20D00D00B").mangledNameHash());
    ASSERT_EQ(0x000007aau, ImmutableString("imageAtomicCompSwap(00z10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007abu, ImmutableString("imageAtomicCompSwap(01K10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007acu, ImmutableString("imageAtomicCompSwap(01V10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007adu, ImmutableString("imageAtomicCompSwap(01A20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007aeu, ImmutableString("imageAtomicCompSwap(01L20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007afu, ImmutableString("imageAtomicCompSwap(01W20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b0u, ImmutableString("imageAtomicCompSwap(01C20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b1u, ImmutableString("imageAtomicCompSwap(01N20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b2u, ImmutableString("imageAtomicCompSwap(01Y20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b3u, ImmutableString("imageAtomicCompSwap(01J00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b4u, ImmutableString("imageAtomicCompSwap(01U00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b5u, ImmutableString("imageAtomicCompSwap(01f00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b6u, ImmutableString("imageAtomicCompSwap(01B20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b7u, ImmutableString("imageAtomicCompSwap(01M20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b8u, ImmutableString("imageAtomicCompSwap(01X20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007b9u, ImmutableString("imageAtomicCompSwap(01H20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007bau, ImmutableString("imageAtomicCompSwap(01S20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007bbu, ImmutableString("imageAtomicCompSwap(01d20D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007bcu, ImmutableString("imageAtomicCompSwap(01D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007bdu, ImmutableString("imageAtomicCompSwap(01O00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007beu, ImmutableString("imageAtomicCompSwap(01Z00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007bfu, ImmutableString("imageAtomicCompSwap(01E10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c0u, ImmutableString("imageAtomicCompSwap(01P10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c1u, ImmutableString("imageAtomicCompSwap(01a10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c2u, ImmutableString("imageAtomicCompSwap(01I10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c3u, ImmutableString("imageAtomicCompSwap(01T10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c4u, ImmutableString("imageAtomicCompSwap(01e10D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c5u,
              ImmutableString("imageAtomicCompSwap(01F10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c6u,
              ImmutableString("imageAtomicCompSwap(01Q10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c7u,
              ImmutableString("imageAtomicCompSwap(01b10D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c8u,
              ImmutableString("imageAtomicCompSwap(01G20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007c9u,
              ImmutableString("imageAtomicCompSwap(01R20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007cau,
              ImmutableString("imageAtomicCompSwap(01c20D00D00E00E").mangledNameHash());
    ASSERT_EQ(0x000007cbu, ImmutableString("imageAtomicCompSwap(00z10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007ccu, ImmutableString("imageAtomicCompSwap(01K10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007cdu, ImmutableString("imageAtomicCompSwap(01V10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007ceu, ImmutableString("imageAtomicCompSwap(01A20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007cfu, ImmutableString("imageAtomicCompSwap(01L20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d0u, ImmutableString("imageAtomicCompSwap(01W20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d1u, ImmutableString("imageAtomicCompSwap(01C20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d2u, ImmutableString("imageAtomicCompSwap(01N20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d3u, ImmutableString("imageAtomicCompSwap(01Y20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d4u, ImmutableString("imageAtomicCompSwap(01J00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d5u, ImmutableString("imageAtomicCompSwap(01U00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d6u, ImmutableString("imageAtomicCompSwap(01f00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d7u, ImmutableString("imageAtomicCompSwap(01B20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d8u, ImmutableString("imageAtomicCompSwap(01M20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007d9u, ImmutableString("imageAtomicCompSwap(01X20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007dau, ImmutableString("imageAtomicCompSwap(01H20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007dbu, ImmutableString("imageAtomicCompSwap(01S20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007dcu, ImmutableString("imageAtomicCompSwap(01d20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007ddu, ImmutableString("imageAtomicCompSwap(01D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007deu, ImmutableString("imageAtomicCompSwap(01O00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007dfu, ImmutableString("imageAtomicCompSwap(01Z00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e0u, ImmutableString("imageAtomicCompSwap(01E10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e1u, ImmutableString("imageAtomicCompSwap(01P10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e2u, ImmutableString("imageAtomicCompSwap(01a10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e3u, ImmutableString("imageAtomicCompSwap(01I10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e4u, ImmutableString("imageAtomicCompSwap(01T10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e5u, ImmutableString("imageAtomicCompSwap(01e10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e6u,
              ImmutableString("imageAtomicCompSwap(01F10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e7u,
              ImmutableString("imageAtomicCompSwap(01Q10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e8u,
              ImmutableString("imageAtomicCompSwap(01b10D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007e9u,
              ImmutableString("imageAtomicCompSwap(01G20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007eau,
              ImmutableString("imageAtomicCompSwap(01R20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007ebu,
              ImmutableString("imageAtomicCompSwap(01c20D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000007ecu, ImmutableString("pixelLocalLoadANGLE(01g").mangledNameHash());
    ASSERT_EQ(0x000007edu, ImmutableString("pixelLocalLoadANGLE(01h").mangledNameHash());
    ASSERT_EQ(0x000007eeu, ImmutableString("pixelLocalLoadANGLE(01i").mangledNameHash());
    ASSERT_EQ(0x000007efu, ImmutableString("pixelLocalStoreANGLE(01g30B").mangledNameHash());
    ASSERT_EQ(0x000007f0u, ImmutableString("pixelLocalStoreANGLE(01h30D").mangledNameHash());
    ASSERT_EQ(0x000007f1u, ImmutableString("pixelLocalStoreANGLE(01i30E").mangledNameHash());
    ASSERT_EQ(0x000007f2u, ImmutableString("beginInvocationInterlockNV(").mangledNameHash());
    ASSERT_EQ(0x000007f3u, ImmutableString("endInvocationInterlockNV(").mangledNameHash());
    ASSERT_EQ(0x000007f4u, ImmutableString("beginFragmentShaderOrderingINTEL(").mangledNameHash());
    ASSERT_EQ(0x000007f5u, ImmutableString("beginInvocationInterlockARB(").mangledNameHash());
    ASSERT_EQ(0x000007f6u, ImmutableString("endInvocationInterlockARB(").mangledNameHash());
    ASSERT_EQ(0x000007f7u, ImmutableString("noise1(00B").mangledNameHash());
    ASSERT_EQ(0x000007f8u, ImmutableString("noise1(10B").mangledNameHash());
    ASSERT_EQ(0x000007f9u, ImmutableString("noise1(20B").mangledNameHash());
    ASSERT_EQ(0x000007fau, ImmutableString("noise1(30B").mangledNameHash());
    ASSERT_EQ(0x000007fbu, ImmutableString("noise2(00B").mangledNameHash());
    ASSERT_EQ(0x000007fcu, ImmutableString("noise2(10B").mangledNameHash());
    ASSERT_EQ(0x000007fdu, ImmutableString("noise2(20B").mangledNameHash());
    ASSERT_EQ(0x000007feu, ImmutableString("noise2(30B").mangledNameHash());
    ASSERT_EQ(0x000007ffu, ImmutableString("noise3(00B").mangledNameHash());
    ASSERT_EQ(0x00000800u, ImmutableString("noise3(10B").mangledNameHash());
    ASSERT_EQ(0x00000801u, ImmutableString("noise3(20B").mangledNameHash());
    ASSERT_EQ(0x00000802u, ImmutableString("noise3(30B").mangledNameHash());
    ASSERT_EQ(0x00000803u, ImmutableString("noise4(00B").mangledNameHash());
    ASSERT_EQ(0x00000804u, ImmutableString("noise4(10B").mangledNameHash());
    ASSERT_EQ(0x00000805u, ImmutableString("noise4(20B").mangledNameHash());
    ASSERT_EQ(0x00000806u, ImmutableString("noise4(30B").mangledNameHash());
    ASSERT_EQ(0x00000807u, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000808u, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x00000809u, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x0000080au, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x0000080bu, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x0000080cu, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x0000080du, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x0000080eu, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x0000080fu, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x00000810u, ImmutableString("EmitStreamVertex(00D").mangledNameHash());
    ASSERT_EQ(0x00000811u, ImmutableString("EndStreamPrimitive(00D").mangledNameHash());
    ASSERT_EQ(0x00000812u, ImmutableString("subpassLoad(01j").mangledNameHash());
    ASSERT_EQ(0x00000813u, ImmutableString("subpassLoad(01k").mangledNameHash());
    ASSERT_EQ(0x00000814u, ImmutableString("subpassLoad(01l").mangledNameHash());
    ASSERT_EQ(0x00000815u, ImmutableString("subpassLoad(01m00D").mangledNameHash());
    ASSERT_EQ(0x00000816u, ImmutableString("subpassLoad(01n00D").mangledNameHash());
    ASSERT_EQ(0x00000817u, ImmutableString("subpassLoad(01o00D").mangledNameHash());
    ASSERT_EQ(0x00000818u, ImmutableString("anyInvocation(00F").mangledNameHash());
    ASSERT_EQ(0x00000819u, ImmutableString("allInvocations(00F").mangledNameHash());
    ASSERT_EQ(0x0000081au, ImmutableString("allInvocationsEqual(00F").mangledNameHash());
    ASSERT_EQ(0x0000081bu, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x0000081cu, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x0000081du, ImmutableString("gl_NumSamples").mangledNameHash());
    ASSERT_EQ(0x0000081eu, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x0000081fu, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000820u, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000821u, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000822u, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000823u, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000824u, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x00000825u, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x00000826u, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x00000827u, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x00000828u, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x00000829u, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x0000082au, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x0000082bu, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000082cu, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000082du, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000082eu, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000082fu, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000830u,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x00000831u, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x00000832u, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x00000833u, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000834u, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000835u, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000836u, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000837u, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000838u, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000839u, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000083au, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x0000083bu, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000083cu, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000083du, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000083eu, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x0000083fu, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000840u, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000841u, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000842u, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000843u, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x00000844u,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000845u, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000846u, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000847u, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000848u, ImmutableString("gl_MaxTessControlInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000849u, ImmutableString("gl_MaxTessControlOutputComponents").mangledNameHash());
    ASSERT_EQ(0x0000084au, ImmutableString("gl_MaxTessControlTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000084bu, ImmutableString("gl_MaxTessControlUniformComponents").mangledNameHash());
    ASSERT_EQ(0x0000084cu,
              ImmutableString("gl_MaxTessControlTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x0000084du, ImmutableString("gl_MaxTessControlImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000084eu, ImmutableString("gl_MaxTessControlAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000084fu,
              ImmutableString("gl_MaxTessControlAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000850u, ImmutableString("gl_MaxTessPatchComponents").mangledNameHash());
    ASSERT_EQ(0x00000851u, ImmutableString("gl_MaxPatchVertices").mangledNameHash());
    ASSERT_EQ(0x00000852u, ImmutableString("gl_MaxTessGenLevel").mangledNameHash());
    ASSERT_EQ(0x00000853u,
              ImmutableString("gl_MaxTessEvaluationInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000854u,
              ImmutableString("gl_MaxTessEvaluationOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000855u,
              ImmutableString("gl_MaxTessEvaluationTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000856u,
              ImmutableString("gl_MaxTessEvaluationUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000857u, ImmutableString("gl_MaxTessEvaluationImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000858u, ImmutableString("gl_MaxTessEvaluationAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000859u,
              ImmutableString("gl_MaxTessEvaluationAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000085au, ImmutableString("gl_MaxSamples").mangledNameHash());
    ASSERT_EQ(0x0000085bu, ImmutableString("gl_MaxClipDistances").mangledNameHash());
    ASSERT_EQ(0x0000085cu, ImmutableString("gl_MaxCullDistances").mangledNameHash());
    ASSERT_EQ(0x0000085du, ImmutableString("gl_MaxCombinedClipAndCullDistances").mangledNameHash());
    ASSERT_EQ(0x0000085eu, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x0000085fu, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x00000860u, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x00000861u, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x00000862u, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x00000863u, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x00000864u, ImmutableString("gl_HelperInvocation").mangledNameHash());
    ASSERT_EQ(0x00000865u, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x00000866u, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x00000867u, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x00000868u, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x00000869u, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x0000086au, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x0000086bu, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x0000086cu, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x0000086du, ImmutableString("gl_SampleID").mangledNameHash());
    ASSERT_EQ(0x0000086eu, ImmutableString("gl_SamplePosition").mangledNameHash());
    ASSERT_EQ(0x0000086fu, ImmutableString("gl_SampleMaskIn").mangledNameHash());
    ASSERT_EQ(0x00000870u, ImmutableString("gl_SampleMask").mangledNameHash());
    ASSERT_EQ(0x00000871u, ImmutableString("gl_CullDistance").mangledNameHash());
    ASSERT_EQ(0x00000872u, ImmutableString("gl_ClipDistance").mangledNameHash());
    ASSERT_EQ(0x00000873u, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x00000874u, ImmutableString("gl_PointSize").mangledNameHash());
    ASSERT_EQ(0x00000875u, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x00000877u, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x0000087au, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x0000087bu, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x0000087cu, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x0000087du, ImmutableString("angle_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x0000087eu, ImmutableString("angle_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x0000087fu, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x00000880u, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x00000881u, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x00000882u, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x00000883u, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x00000884u, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x00000885u, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x00000886u, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x00000887u, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x00000888u, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x00000889u, ImmutableString("gl_PatchVerticesIn").mangledNameHash());
    ASSERT_EQ(0x0000088au, ImmutableString("gl_TessLevelOuter").mangledNameHash());
    ASSERT_EQ(0x0000088bu, ImmutableString("gl_TessLevelInner").mangledNameHash());
    ASSERT_EQ(0x0000088cu, ImmutableString("gl_out").mangledNameHash());
    ASSERT_EQ(0x0000088du, ImmutableString("gl_BoundingBox").mangledNameHash());
    ASSERT_EQ(0x0000088eu, ImmutableString("gl_BoundingBoxEXT").mangledNameHash());
    ASSERT_EQ(0x0000088fu, ImmutableString("gl_BoundingBoxOES").mangledNameHash());
    ASSERT_EQ(0x00000890u, ImmutableString("gl_TessCoord").mangledNameHash());
    ASSERT_EQ(0x00000891u, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("radians").unmangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("degrees").unmangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("sin").unmangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("cos").unmangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("tan").unmangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("asin").unmangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("acos").unmangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("atan").unmangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("sinh").unmangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("cosh").unmangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("tanh").unmangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("asinh").unmangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("acosh").unmangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("atanh").unmangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("pow").unmangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("exp").unmangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("log").unmangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("exp2").unmangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("log2").unmangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("sqrt").unmangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("inversesqrt").unmangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("abs").unmangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("sign").unmangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("floor").unmangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("trunc").unmangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("round").unmangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("roundEven").unmangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("ceil").unmangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("fract").unmangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("mod").unmangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("min").unmangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("max").unmangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("clamp").unmangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("mix").unmangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("step").unmangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("smoothstep").unmangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("modf").unmangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("isnan").unmangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("isinf").unmangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("floatBitsToInt").unmangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("floatBitsToUint").unmangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("intBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("uintBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("fma").unmangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("frexp").unmangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("ldexp").unmangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("packSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("packHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("unpackSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("unpackHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("packUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("unpackUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("packUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("packSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("unpackUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("unpackSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("packDouble2x32").unmangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("unpackDouble2x32").unmangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("length").unmangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("distance").unmangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("dot").unmangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("cross").unmangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("normalize").unmangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("faceforward").unmangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("reflect").unmangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("refract").unmangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("ftransform").unmangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("matrixCompMult").unmangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("outerProduct").unmangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("transpose").unmangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("determinant").unmangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("inverse").unmangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("lessThan").unmangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("lessThanEqual").unmangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("greaterThan").unmangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("greaterThanEqual").unmangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("equal").unmangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("notEqual").unmangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("any").unmangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("all").unmangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("not").unmangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("bitfieldExtract").unmangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("bitfieldInsert").unmangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("bitfieldReverse").unmangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("bitCount").unmangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("findLSB").unmangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("findMSB").unmangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("uaddCarry").unmangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("usubBorrow").unmangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("umulExtended").unmangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("imulExtended").unmangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("texture2D").unmangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("texture2DProj").unmangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("textureCube").unmangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("texture1D").unmangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("texture1DProj").unmangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("texture3D").unmangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("texture3DProj").unmangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("shadow1D").unmangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("shadow1DProj").unmangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("shadow2D").unmangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("shadow2DProj").unmangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("shadow2DEXT").unmangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("shadow2DProjEXT").unmangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("texture2DRect").unmangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("texture2DRectProj").unmangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("texture2DGradEXT").unmangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("texture2DProjGradEXT").unmangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("textureCubeGradEXT").unmangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("textureVideoWEBGL").unmangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("texture2DLod").unmangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("texture2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("textureCubeLod").unmangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("texture1DLod").unmangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("texture1DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("shadow1DLod").unmangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("shadow1DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("shadow2DLod").unmangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("shadow2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("texture3DLod").unmangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("texture3DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("texture2DLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("texture2DProjLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("textureCubeLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("texture").unmangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("textureProj").unmangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("textureLod").unmangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("textureSize").unmangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("textureProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("texelFetch").unmangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("textureGrad").unmangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("textureProjGrad").unmangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("textureQueryLevels").unmangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("textureSamples").unmangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("textureQueryLod").unmangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("textureOffset").unmangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("textureProjOffset").unmangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("textureLodOffset").unmangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("textureProjLodOffset").unmangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("texelFetchOffset").unmangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("textureGradOffset").unmangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("textureProjGradOffset").unmangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("textureGather").unmangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("textureGatherOffset").unmangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("textureGatherOffsets").unmangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("rgb_2_yuv").unmangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("yuv_2_rgb").unmangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("dFdx").unmangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("dFdy").unmangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("fwidth").unmangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("dFdxFine").unmangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("dFdyFine").unmangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("dFdxCoarse").unmangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("dFdyCoarse").unmangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("fwidthFine").unmangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("fwidthCoarse").unmangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("interpolateAtCentroid").unmangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("interpolateAtSample").unmangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("interpolateAtOffset").unmangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("atomicCounter").unmangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("atomicCounterIncrement").unmangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("atomicCounterDecrement").unmangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("atomicCounterAdd").unmangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("atomicCounterSubtract").unmangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("atomicCounterMin").unmangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("atomicCounterMax").unmangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("atomicCounterAnd").unmangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("atomicCounterOr").unmangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("atomicCounterXor").unmangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("atomicCounterExchange").unmangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("atomicCounterCompSwap").unmangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("atomicAdd").unmangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("atomicMin").unmangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("atomicMax").unmangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("atomicAnd").unmangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("atomicOr").unmangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("atomicXor").unmangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("atomicExchange").unmangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("atomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("imageSize").unmangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("imageSamples").unmangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("imageStore").unmangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("imageLoad").unmangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("imageAtomicAdd").unmangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("imageAtomicMin").unmangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("imageAtomicMax").unmangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("imageAtomicAnd").unmangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("imageAtomicOr").unmangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("imageAtomicXor").unmangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("imageAtomicExchange").unmangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("imageAtomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("pixelLocalLoadANGLE").unmangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("pixelLocalStoreANGLE").unmangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("beginInvocationInterlockNV").unmangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("endInvocationInterlockNV").unmangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("beginFragmentShaderOrderingINTEL").unmangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("beginInvocationInterlockARB").unmangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("endInvocationInterlockARB").unmangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("noise1").unmangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("noise2").unmangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("noise3").unmangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("noise4").unmangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("memoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("memoryBarrierAtomicCounter").unmangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("memoryBarrierBuffer").unmangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("memoryBarrierImage").unmangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("barrier").unmangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("memoryBarrierShared").unmangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("groupMemoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("EmitVertex").unmangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("EndPrimitive").unmangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("EmitStreamVertex").unmangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("EndStreamPrimitive").unmangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("subpassLoad").unmangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("anyInvocation").unmangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("allInvocations").unmangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("allInvocationsEqual").unmangledNameHash());
}

}  // namespace sh
