// GENERATED FILE - DO NOT EDIT.
// Generated by gen_restricted_traces.py using data from restricted_traces.json
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Types and enumerations for trace tests.

#ifndef ANGLE_RESTRICTED_TRACES_H_
#define ANGLE_RESTRICTED_TRACES_H_

#include "egypt_1500/egypt_1500_capture_context1.h"
#include "manhattan_10/manhattan_10_capture_context1.h"
#include "temple_run_300/temple_run_300_capture_context3.h"
#include "trex_200/trex_200_capture_context1.h"

namespace angle
{
enum class RestrictedTraceID
{
    egypt_1500,
    manhattan_10,
    temple_run_300,
    trex_200,
    InvalidEnum,
    EnumCount = InvalidEnum
};

using ReplayFunc           = void (*)(uint32_t);
using ResetFunc            = void (*)();
using SetupFunc            = void (*)();
using DecompressFunc       = uint8_t *(*)(const std::vector<uint8_t> &);
using SetBinaryDataDirFunc = void (*)(const char *);

static constexpr size_t kTraceInfoMaxNameLen = 32;

struct TraceInfo
{
    uint32_t startFrame;
    uint32_t endFrame;
    char name[kTraceInfoMaxNameLen];
};

constexpr angle::PackedEnumMap<RestrictedTraceID, TraceInfo> kTraceInfos = {
    {RestrictedTraceID::egypt_1500,
     {egypt_1500::kReplayFrameStart, egypt_1500::kReplayFrameEnd, "egypt_1500"}},
    {RestrictedTraceID::manhattan_10,
     {manhattan_10::kReplayFrameStart, manhattan_10::kReplayFrameEnd, "manhattan_10"}},
    {RestrictedTraceID::temple_run_300,
     {temple_run_300::kReplayFrameStart, temple_run_300::kReplayFrameEnd, "temple_run_300"}},
    {RestrictedTraceID::trex_200,
     {trex_200::kReplayFrameStart, trex_200::kReplayFrameEnd, "trex_200"}}};

using DecompressCallback        = uint8_t *(*)(const std::vector<uint8_t> &);
using FramebufferChangeCallback = void (*)(void *userData, GLenum target, GLuint framebuffer);

inline void ReplayFrame(RestrictedTraceID traceID, uint32_t frameIndex)
{
    switch (traceID)
    {
        case RestrictedTraceID::egypt_1500:
            egypt_1500::ReplayContext1Frame(frameIndex);
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::ReplayContext1Frame(frameIndex);
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::ReplayContext3Frame(frameIndex);
            break;
        case RestrictedTraceID::trex_200:
            trex_200::ReplayContext1Frame(frameIndex);
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

inline void ResetReplay(RestrictedTraceID traceID)
{
    switch (traceID)
    {
        case RestrictedTraceID::egypt_1500:
            egypt_1500::ResetContext1Replay();
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::ResetContext1Replay();
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::ResetContext3Replay();
            break;
        case RestrictedTraceID::trex_200:
            trex_200::ResetContext1Replay();
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

inline void SetupReplay(RestrictedTraceID traceID)
{
    switch (traceID)
    {
        case RestrictedTraceID::egypt_1500:
            egypt_1500::SetupContext1Replay();
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::SetupContext1Replay();
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::SetupContext3Replay();
            break;
        case RestrictedTraceID::trex_200:
            trex_200::SetupContext1Replay();
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

inline void SetBinaryDataDir(RestrictedTraceID traceID, const char *dataDir)
{
    switch (traceID)
    {
        case RestrictedTraceID::egypt_1500:
            egypt_1500::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::SetBinaryDataDir(dataDir);
            break;
        case RestrictedTraceID::trex_200:
            trex_200::SetBinaryDataDir(dataDir);
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

inline void SetBinaryDataDecompressCallback(RestrictedTraceID traceID, DecompressCallback callback)
{
    switch (traceID)
    {
        case RestrictedTraceID::egypt_1500:
            egypt_1500::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::SetBinaryDataDecompressCallback(callback);
            break;
        case RestrictedTraceID::trex_200:
            trex_200::SetBinaryDataDecompressCallback(callback);
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}

inline void SetFramebufferChangeCallback(RestrictedTraceID traceID,
                                         void *userData,
                                         FramebufferChangeCallback callback)
{
    switch (traceID)
    {
        case RestrictedTraceID::egypt_1500:
            egypt_1500::SetFramebufferChangeCallback(userData, callback);
            break;
        case RestrictedTraceID::manhattan_10:
            manhattan_10::SetFramebufferChangeCallback(userData, callback);
            break;
        case RestrictedTraceID::temple_run_300:
            temple_run_300::SetFramebufferChangeCallback(userData, callback);
            break;
        case RestrictedTraceID::trex_200:
            trex_200::SetFramebufferChangeCallback(userData, callback);
            break;
        default:
            fprintf(stderr, "Error in switch.\n");
            assert(0);
            break;
    }
}
}  // namespace angle

#endif  // ANGLE_RESTRICTED_TRACES_H_
