// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

std::ostream &operator<<(std::ostream &os, const sh::ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {417,  3313, 3044, 680,  2508, 3561, 1073, 351,  457,  1363,
                              1704, 3701, 2117, 3388, 1046, 3102, 4330, 1835, 3825, 249,
                              345,  1171, 4152, 3215, 3212, 3745, 2872, 3795, 3526, 3916,
                              2870, 642,  326,  585,  2346, 2144, 2595};
constexpr int mangledkT2[] = {173,  3815, 3691, 3308, 3907, 1340, 3432, 3919, 2665, 3544,
                              3700, 2906, 3546, 3971, 952,  918,  2735, 3910, 3624, 3624,
                              689,  3012, 1300, 3916, 1468, 4198, 864,  1975, 3174, 2392,
                              2885, 3797, 379,  3769, 1054, 4303, 2029};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    0,    0,    0,    0,    4046, 0,    0,    0,    3913, 0,    0,    0,
    0,    1688, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1126, 0,
    0,    0,    0,    0,    0,    0,    0,    1324, 0,    0,    559,  3047, 0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    1220, 3078, 4432, 0,    0,    0,    4398,
    1246, 0,    0,    0,    2758, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1024, 0,
    0,    0,    0,    4156, 0,    0,    0,    0,    0,    2014, 0,    0,    0,    0,    0,    0,
    3409, 1575, 0,    1860, 818,  1854, 0,    0,    2843, 0,    0,    0,    0,    0,    376,  0,
    0,    0,    0,    0,    0,    0,    3906, 0,    982,  0,    0,    0,    1719, 0,    0,    0,
    0,    0,    0,    0,    0,    240,  0,    0,    0,    829,  0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    4174, 0,    0,    0,
    0,    0,    296,  1398, 0,    1665, 0,    0,    67,   0,    853,  0,    0,    2957, 0,    0,
    2419, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    1211, 0,    0,    3659, 0,    0,    0,    0,    0,    0,    0,
    240,  0,    1545, 1946, 0,    0,    0,    2341, 0,    0,    0,    0,    0,    0,    2096, 0,
    0,    3018, 0,    0,    0,    0,    0,    2306, 984,  14,   0,    0,    0,    3367, 0,    0,
    4406, 0,    0,    0,    0,    3898, 0,    0,    354,  0,    0,    0,    0,    4386, 0,    2046,
    0,    0,    0,    0,    0,    1234, 0,    1483, 0,    0,    4335, 228,  2659, 0,    526,  0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1896, 0,    0,    0,    0,
    0,    0,    1728, 0,    0,    0,    2163, 1841, 3798, 0,    0,    0,    890,  0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    872,  0,    0,    0,    0,    0,    503,  0,
    333,  1676, 0,    0,    4356, 2068, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    798,  0,    115,  1536, 0,    0,    0,    0,    4327, 0,    0,    0,    0,    0,    0,    0,
    3513, 0,    0,    0,    0,    4035, 999,  764,  0,    0,    0,    0,    0,    0,    0,    1127,
    2850, 0,    0,    0,    0,    0,    0,    0,    0,    3897, 0,    0,    0,    0,    0,    0,
    0,    2732, 1387, 0,    0,    0,    0,    0,    0,    0,    0,    0,    773,  3079, 0,    0,
    0,    1425, 0,    0,    0,    874,  306,  0,    0,    0,    0,    0,    0,    0,    0,    0,
    1153, 0,    0,    1232, 0,    0,    0,    1208, 0,    0,    0,    0,    0,    3898, 0,    0,
    0,    0,    0,    0,    0,    1706, 3200, 3292, 1993, 0,    1020, 3202, 0,    0,    0,    0,
    2043, 862,  0,    3541, 0,    0,    3985, 0,    0,    0,    0,    0,    0,    75,   0,    0,
    0,    0,    3555, 1345, 640,  0,    0,    0,    0,    0,    0,    0,    2041, 0,    3950, 874,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3176, 412,
    0,    0,    0,    0,    4409, 0,    0,    3255, 0,    0,    0,    0,    0,    0,    0,    0,
    896,  0,    0,    0,    4344, 4215, 0,    0,    3028, 0,    0,    0,    1697, 269,  0,    0,
    0,    0,    1530, 0,    0,    4216, 1620, 0,    0,    0,    0,    611,  498,  0,    0,    452,
    0,    0,    0,    0,    0,    0,    0,    0,    1,    0,    0,    1757, 0,    0,    117,  1172,
    0,    900,  4137, 0,    0,    3639, 1838, 0,    0,    793,  0,    0,    0,    0,    191,  0,
    0,    0,    0,    2407, 0,    0,    0,    311,  0,    0,    0,    0,    824,  0,    1560, 0,
    0,    2105, 0,    0,    1522, 4347, 0,    1445, 1601, 0,    3674, 0,    2444, 0,    0,    0,
    0,    1467, 1387, 3874, 2896, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    2099, 0,    0,    3277, 0,    1100, 0,    0,    2418, 0,    0,    1616, 0,    3212, 0,    328,
    0,    0,    0,    2574, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    773,  0,    0,    0,    0,    1652, 0,    2750, 955,  719,  0,    0,    0,    0,    383,  0,
    0,    0,    0,    0,    0,    0,    0,    1385, 0,    0,    84,   0,    0,    0,    3263, 0,
    0,    0,    3517, 0,    0,    0,    0,    0,    1634, 0,    1931, 2758, 0,    0,    0,    0,
    3887, 570,  851,  0,    0,    1408, 1789, 0,    0,    1637, 590,  0,    0,    0,    0,    891,
    0,    0,    0,    2412, 0,    0,    0,    0,    0,    0,    3824, 0,    0,    131,  0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    909,  0,    0,    0,    0,    0,    0,    3632,
    0,    0,    0,    0,    0,    876,  0,    0,    1684, 0,    3820, 0,    0,    0,    0,    1902,
    2531, 677,  0,    3733, 1261, 139,  1652, 0,    0,    0,    1331, 1631, 0,    0,    0,    0,
    0,    515,  1197, 645,  0,    2137, 203,  0,    0,    0,    0,    369,  469,  0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    1816, 782,  0,    3192, 0,    1959, 0,
    243,  0,    573,  0,    0,    0,    3141, 0,    0,    0,    0,    0,    290,  1751, 0,    0,
    1943, 0,    0,    1021, 2402, 0,    2671, 0,    2747, 4067, 0,    0,    0,    0,    0,    0,
    3845, 4125, 0,    356,  0,    0,    2585, 0,    0,    0,    1626, 0,    0,    4289, 0,    0,
    0,    0,    990,  916,  302,  0,    0,    0,    0,    0,    2310, 0,    4383, 0,    0,    2396,
    0,    4088, 1847, 0,    3847, 0,    0,    0,    0,    0,    0,    0,    315,  0,    0,    1091,
    0,    0,    0,    2669, 0,    4148, 0,    0,    0,    0,    630,  0,    251,  0,    3728, 0,
    1546, 1879, 0,    3815, 0,    1548, 1389, 0,    2596, 3228, 314,  3563, 3798, 0,    206,  3170,
    0,    0,    2316, 0,    3357, 3608, 0,    0,    466,  0,    101,  3756, 0,    0,    0,    2093,
    780,  0,    0,    0,    2844, 0,    0,    0,    0,    0,    1190, 201,  0,    0,    0,    0,
    0,    480,  0,    4413, 4024, 0,    36,   0,    0,    1795, 1037, 0,    0,    0,    3440, 1528,
    0,    0,    1643, 0,    3495, 0,    0,    1786, 0,    0,    0,    0,    0,    0,    0,    90,
    3083, 3508, 3718, 2824, 0,    0,    3774, 0,    0,    0,    0,    150,  0,    0,    4245, 0,
    1010, 1446, 0,    0,    0,    0,    0,    981,  0,    689,  0,    422,  0,    0,    4075, 0,
    0,    0,    0,    739,  316,  0,    0,    0,    0,    964,  0,    1060, 0,    0,    3893, 0,
    1724, 126,  0,    0,    0,    428,  3764, 0,    411,  0,    0,    0,    0,    0,    1164, 3790,
    0,    0,    0,    454,  879,  0,    0,    0,    1677, 0,    1093, 0,    1249, 843,  524,  0,
    0,    0,    3691, 0,    0,    1343, 3408, 0,    0,    1798, 0,    251,  0,    0,    0,    0,
    0,    4121, 0,    0,    3993, 1416, 0,    779,  0,    0,    0,    0,    0,    2935, 0,    0,
    930,  0,    749,  0,    0,    0,    0,    499,  0,    1031, 2063, 1762, 1334, 2398, 0,    875,
    0,    1016, 0,    0,    0,    0,    0,    0,    0,    273,  2030, 1220, 0,    0,    3271, 0,
    0,    0,    0,    1910, 0,    0,    0,    0,    0,    0,    0,    0,    597,  1737, 2139, 0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    79,   0,    1123, 0,    0,
    1124, 3860, 203,  675,  0,    4057, 0,    0,    745,  0,    0,    0,    1175, 0,    3140, 64,
    0,    2640, 0,    104,  0,    2072, 772,  0,    0,    0,    0,    547,  0,    0,    0,    1312,
    0,    0,    0,    0,    1870, 0,    3993, 2934, 0,    0,    2777, 0,    4314, 648,  0,    677,
    0,    2942, 0,    452,  0,    3622, 0,    4209, 0,    0,    1009, 0,    0,    0,    0,    0,
    1023, 0,    312,  1713, 1127, 0,    866,  0,    0,    0,    0,    0,    2113, 510,  4204, 0,
    0,    0,    0,    0,    645,  213,  0,    0,    1985, 1181, 0,    1408, 165,  931,  76,   0,
    0,    1291, 4264, 0,    1507, 1278, 0,    0,    0,    0,    630,  0,    0,    513,  1092, 4033,
    0,    4339, 930,  0,    450,  1569, 4389, 0,    0,    0,    0,    982,  0,    0,    897,  0,
    1706, 0,    1963, 0,    0,    789,  2035, 0,    813,  342,  0,    3001, 0,    230,  0,    2916,
    0,    0,    2637, 1897, 0,    0,    0,    0,    0,    882,  37,   0,    2120, 0,    2968, 0,
    0,    567,  0,    3458, 0,    0,    0,    0,    730,  0,    3579, 0,    1364, 0,    0,    4416,
    0,    0,    3773, 1046, 3779, 0,    540,  1666, 1678, 0,    822,  0,    0,    0,    0,    0,
    0,    900,  1908, 0,    0,    0,    4332, 4273, 1025, 739,  2558, 216,  368,  0,    0,    0,
    2454, 857,  0,    148,  451,  0,    0,    170,  0,    0,    1104, 0,    216,  0,    1662, 782,
    0,    0,    0,    1240, 1098, 4298, 0,    0,    0,    0,    449,  0,    0,    0,    69,   0,
    0,    0,    669,  0,    797,  0,    266,  2615, 2513, 0,    1231, 0,    1362, 0,    0,    0,
    2775, 0,    165,  0,    0,    0,    1516, 0,    963,  0,    0,    0,    805,  0,    0,    0,
    0,    0,    1258, 0,    4209, 0,    1035, 84,   0,    760,  0,    2044, 0,    0,    1164, 42,
    1205, 35,   0,    3565, 2849, 0,    2741, 2048, 0,    2451, 0,    0,    0,    0,    0,    0,
    2880, 720,  1617, 0,    1493, 0,    0,    0,    0,    3678, 0,    0,    2489, 0,    2423, 0,
    1279, 469,  3735, 408,  0,    2886, 0,    0,    0,    0,    0,    0,    1616, 223,  3639, 923,
    1892, 0,    3758, 0,    0,    0,    0,    3901, 1934, 0,    0,    0,    0,    0,    31,   962,
    3425, 0,    169,  766,  169,  0,    0,    369,  0,    137,  2234, 0,    0,    0,    1699, 3838,
    3523, 561,  109,  3650, 0,    1784, 3960, 1203, 0,    0,    0,    0,    0,    86,   0,    0,
    2396, 0,    1855, 0,    0,    0,    0,    0,    3004, 0,    2934, 904,  0,    4399, 29,   0,
    902,  1046, 3238, 0,    0,    0,    1763, 0,    628,  0,    0,    88,   0,    0,    2368, 0,
    0,    0,    704,  2780, 0,    604,  0,    0,    360,  4304, 2313, 271,  0,    0,    0,    222,
    3006, 880,  0,    3146, 1328, 1562, 1138, 101,  4260, 84,   1737, 1511, 4327, 0,    2211, 1612,
    0,    0,    0,    952,  0,    3654, 1919, 1720, 0,    0,    0,    1716, 3380, 1891, 0,    1351,
    0,    97,   0,    0,    3450, 0,    3751, 3934, 0,    0,    704,  0,    0,    0,    0,    0,
    1929, 94,   0,    1166, 0,    60,   0,    87,   0,    1128, 0,    0,    654,  0,    4131, 1291,
    0,    175,  0,    700,  1706, 0,    0,    0,    0,    0,    0,    180,  1705, 2132, 235,  0,
    1290, 578,  0,    815,  0,    0,    4050, 0,    0,    0,    163,  0,    2590, 0,    0,    0,
    0,    0,    347,  0,    1960, 0,    0,    3038, 0,    3307, 3297, 0,    0,    1848, 0,    1211,
    0,    0,    0,    0,    0,    2903, 50,   64,   2403, 1253, 0,    622,  0,    0,    1984, 3035,
    0,    0,    1332, 3984, 1098, 4181, 0,    0,    0,    623,  0,    1503, 0,    0,    1202, 0,
    405,  281,  0,    2447, 0,    0,    1010, 0,    192,  0,    3923, 554,  0,    0,    0,    1216,
    0,    354,  1150, 0,    3779, 0,    0,    0,    1086, 1257, 4383, 0,    0,    4128, 0,    3408,
    3718, 3991, 0,    0,    0,    2006, 0,    0,    3731, 0,    0,    4216, 1907, 1880, 0,    0,
    1698, 1335, 812,  0,    0,    0,    4173, 0,    3273, 0,    0,    881,  0,    4111, 0,    0,
    0,    0,    1740, 0,    991,  4135, 0,    0,    0,    99,   3182, 0,    3246, 1752, 1853, 0,
    2670, 0,    2896, 2800, 1790, 208,  1188, 0,    3136, 0,    292,  1489, 641,  1693, 0,    1837,
    413,  2584, 0,    0,    0,    0,    0,    373,  0,    2199, 362,  4049, 2535, 57,   2776, 0,
    3416, 0,    0,    1123, 0,    2573, 0,    0,    416,  2966, 0,    716,  0,    455,  0,    1352,
    0,    0,    1086, 1996, 444,  2239, 914,  0,    3600, 0,    0,    0,    0,    0,    1159, 0,
    0,    99,   4250, 0,    2033, 3204, 3970, 0,    446,  0,    0,    0,    0,    0,    1869, 2409,
    0,    0,    0,    0,    1341, 0,    1696, 0,    589,  0,    3326, 4332, 0,    0,    3146, 0,
    0,    0,    0,    195,  0,    0,    0,    0,    0,    374,  2590, 2571, 1804, 0,    0,    0,
    0,    178,  1641, 444,  4049, 0,    4038, 575,  0,    0,    258,  1456, 0,    0,    2000, 1085,
    0,    1911, 0,    0,    0,    3651, 0,    311,  1771, 0,    4083, 2800, 0,    0,    0,    0,
    0,    553,  534,  0,    440,  0,    0,    2082, 0,    0,    0,    2524, 1559, 4115, 2154, 0,
    0,    0,    389,  0,    363,  0,    871,  2076, 1097, 3734, 3674, 0,    244,  3638, 0,    1541,
    0,    203,  1051, 1630, 0,    0,    2713, 0,    0,    0,    915,  0,    0,    0,    2988, 0,
    0,    0,    0,    4329, 3873, 0,    0,    1676, 0,    0,    0,    1839, 1017, 560,  0,    0,
    4372, 0,    0,    169,  0,    0,    0,    0,    0,    0,    143,  0,    0,    0,    44,   1440,
    397,  0,    0,    158,  0,    709,  0,    2456, 2069, 4250, 0,    1729, 0,    0,    0,    0,
    1508, 0,    0,    68,   0,    0,    443,  2979, 2402, 0,    0,    0,    0,    3208, 0,    2317,
    0,    37,   376,  4204, 0,    2224, 0,    0,    50,   219,  729,  3407, 1141, 0,    1769, 0,
    563,  451,  193,  238,  58,   3468, 0,    3863, 0,    91,   1053, 0,    2888, 0,    1887, 4176,
    0,    620,  0,    478,  0,    0,    1481, 0,    4074, 0,    0,    0,    596,  0,    0,    0,
    1435, 0,    2441, 1374, 0,    0,    4208, 2090, 0,    0,    0,    3760, 0,    0,    1134, 109,
    2325, 797,  0,    0,    0,    996,  497,  1077, 0,    2551, 329,  322,  0,    0,    1925, 0,
    0,    1118, 0,    1481, 3885, 0,    261,  0,    0,    0,    0,    0,    0,    174,  0,    0,
    0,    1376, 0,    1617, 0,    576,  0,    3778, 0,    961,  1375, 4359, 0,    1542, 143,  0,
    733,  0,    4026, 2149, 0,    1675, 339,  1811, 0,    0,    0,    1612, 0,    0,    2146, 0,
    0,    0,    3890, 0,    218,  0,    1250, 0,    4070, 0,    0,    2363, 4280, 231,  0,    0,
    1236, 1568, 3398, 448,  0,    0,    3680, 674,  0,    1743, 0,    0,    4012, 830,  3922, 1380,
    658,  0,    2166, 293,  1824, 0,    0,    1102, 0,    3662, 1902, 228,  0,    0,    0,    0,
    0,    41,   1793, 2577, 0,    0,    726,  4196, 0,    0,    0,    0,    2824, 0,    0,    4408,
    0,    0,    0,    1779, 3767, 3623, 1313, 0,    0,    1780, 0,    1149, 1648, 0,    2360, 0,
    4117, 646,  0,    0,    1661, 2840, 0,    3553, 0,    1867, 2797, 0,    0,    0,    0,    3265,
    799,  4307, 0,    386,  0,    490,  4172, 1695, 0,    0,    0,    696,  0,    524,  480,  3188,
    2035, 891,  0,    0,    0,    0,    1409, 262,  242,  700,  0,    0,    845,  2268, 1247, 1646,
    2602, 0,    1048, 0,    3406, 408,  0,    584,  0,    1680, 0,    0,    2036, 0,    0,    274,
    0,    0,    0,    0,    0,    3781, 0,    168,  4136, 16,   164,  136,  1992, 0,    406,  0,
    0,    1967, 0,    3903, 2555, 0,    1280, 3742, 537,  1272, 966,  797,  2924, 0,    1952, 1013,
    0,    1923, 0,    1397, 1507, 497,  0,    0,    401,  923,  455,  0,    0,    4122, 1592, 4257,
    0,    1350, 1364, 4006, 3958, 0,    1301, 1947, 0,    2168, 818,  187,  0,    0,    0,    1324,
    0,    1438, 1375, 0,    2397, 2984, 0,    1864, 252,  0,    0,    0,    0,    2361, 395,  0,
    2309, 814,  0,    802,  0,    3423, 1205, 0,    0,    465,  0,    0,    0,    4179, 0,    2954,
    4373, 1898, 1202, 2019, 0,    2057, 0,    0,    1190, 1647, 4065, 0,    268,  3437, 0,    678,
    1061, 0,    0,    0,    0,    613,  403,  2081, 0,    0,    2063, 2059, 0,    1683, 1069, 358,
    637,  396,  0,    0,    980,  0,    1211, 1120, 651,  1280, 969,  846,  3385, 4414, 0,    0,
    337,  0,    1750, 788,  1163, 0,    0,    0,    113,  616,  1822, 0,    0,    0,    491,  0,
    0,    1911, 0,    0,    0,    974,  0,    1641, 2128, 0,    0,    0,    0,    650,  419,  345,
    0,    0,    0,    1569, 791,  0,    660,  0,    1915, 361,  1658, 1717, 324,  0,    0,    1290,
    0,    2282, 280,  0,    416,  1629, 0,    2152, 4186, 904,  3459, 0,    0,    2017, 0,    0,
    0,    0,    267,  1207, 1198, 4348, 0,    0,    250,  0,    0,    0,    3204, 1165, 817,  2708,
    1012, 0,    0,    482,  1649, 0,    1745, 0,    980,  761,  0,    0,    3182, 0,    0,    1287,
    0,    0,    905,  410,  1246, 566,  0,    756,  4011, 0,    2273, 2742, 0,    375,  1787, 695,
    0,    3955, 471,  0,    3229, 202,  3939, 1958, 436,  318,  0,    0,    0,    4009, 0,    617,
    1530, 699,  1307, 1945, 0,    2074, 1869, 583,  1664, 120,  1156, 1879, 0,    0,    3457, 1710,
    0,    0,    0,    0,    318,  926,  0,    0,    1650, 0,    0,    957,  0,    0,    0,    0,
    0,    0,    0,    0,    0,    592,  4318, 0,    9,    4355, 911,  973,  0,    3257, 0,    78,
    0,    1024, 0,    0,    0,    3569, 0,    1532, 0,    0,    571,  1217, 350,  0,    0,    0,
    3742, 0,    359,  0,    1178, 0,    0,    839,  1834, 994,  65,   59,   0,    0,    4289, 69,
    0,    0,    0,    2795, 746,  0,    0,    305,  0,    0,    0,    0,    0,    3674, 0,    0,
    0,    3899, 0,    1828, 1851, 2091, 0,    1700, 4120, 913,  0,    188,  0,    3340, 1848, 984,
    0,    0,    4345, 0,    1948, 3914, 1915, 0,    0,    1721, 0,    2950, 0,    0,    0,    0,
    456,  300,  2456, 803,  0,    509,  1737, 0,    0,    0,    0,    2049, 0,    16,   407,  0,
    506,  352,  1668, 1465, 0,    0,    0,    1298, 0,    0,    0,    390,  3405, 0,    0,    0,
    2027, 842,  1321, 1194, 0,    0,    935,  0,    0,    0,    0,    546,  1221, 0,    0,    396,
    1452, 4370, 0,    0,    0,    0,    2029, 0,    0,    826,  1297, 4178, 0,    764,  0,    4253,
    1954, 0,    0,    0,    1357, 0,    1214, 0,    0,    0,    0,    2712, 0,    1269, 0,    2851,
    0,    507,  332,  0,    4198, 0,    0,    0,    1545, 0,    0,    0,    0,    230,  496,  0,
    3648, 0,    1465, 0,    0,    278,  0,    2294, 1121, 0,    832,  0,    1789, 3253, 1445, 3773,
    2820, 512,  4259, 1924, 3447, 0,    0,    0,    1741, 255,  0,    3039, 1501, 0,    2854, 1484,
    1325, 838,  897,  549,  3815, 1736, 0,    129,  3982, 4324, 0,    1955, 2835, 0,    1594, 0,
    686,  4385, 71,   1672, 1799, 4169, 0,    0,    1012, 0,    0,    1686, 0,    864,  0,    1120,
    0,    2792, 0,    0,    1227, 0,    655,  785,  1315, 655,  1893, 0,    0,    0,    3540, 2028,
    0,    3509, 1283, 1075, 0,    0,    0,    4368, 2010, 0,    0,    969,  2626, 4070, 1159, 1998,
    0,    860,  3518, 0,    1754, 4247, 34,   4167, 1467, 0,    1894, 178,  0,    0,    0,    1203,
    0,    0,    1593, 0,    867,  3802, 473,  0,    0,    0,    551,  1061, 972,  0,    0,    0,
    0,    451,  3555, 0,    2097, 3002, 0,    2043, 0,    0,    926,  1990, 1201, 0,    0,    0,
    2083, 690,  0,    0,    0,    0,    0,    0,    1180, 489,  3296, 1558, 2379, 569,  3423, 453,
    574,  0,    0,    0,    511,  798,  0,    0,    0,    1147, 731,  829,  1112, 3623, 0,    0,
    3548, 0,    0,    2031, 1090, 3615, 0,    637,  3063, 0,    292,  499,  0,    0,    0,    2989,
    1413, 611,  1114, 2129, 0,    0,    0,    1303, 4279, 0,    1950, 0,    3053, 1591, 854,  2996,
    1181, 0,    742,  939,  840,  1319, 0,    4025, 3328, 0,    3242, 2929, 2251, 0,    1988, 1670,
    1350, 0,    3672, 0,    0,    0,    3553, 0,    0,    157,  1015, 0,    0,    0,    4053, 1517,
    0,    0,    0,    0,    677,  0,    0,    3545, 750,  599,  0,    0,    4404, 0,    1852, 1513,
    0,    412,  0,    0,    4128, 284,  0,    473,  442,  24,   3048, 0,    455,  0,    2433, 684,
    470,  276,  594,  700,  1282, 0,    0,    0,    1586, 103,  0,    888,  0,    1559, 1476, 841,
    0,    2709, 3176, 1538, 486,  0,    119,  0,    0,    1992, 0,    370,  453,  0,    206,  1839,
    240,  2465, 383,  727,  689,  0,    1083, 4384, 0,    1151, 1688, 0,    2026, 1388, 1075, 0,
    177,  2683, 0,    4405, 1962, 3120, 4162, 0,    0,    247,  720,  0,    0,    714,  1552, 1043,
    417,  0,    197,  0,    729,  1098, 0,    106,  0,    801,  3127, 0,    0,    1459, 309,  0,
    737,  316,  1451, 67,   275,  400,  135,  93,   4001, 3413, 0,    372,  4022, 1371, 146,  4242,
    847,  0,    959,  1431, 4173, 4172, 708,  0,    249,  3339, 112,  0,    1866, 2450, 3786, 0,
    1653, 1627, 0,    0,    0,    0,    4325, 1809, 351,  1199, 3317, 0,    4271, 1685, 883,  2360,
    939,  836,  0,    0,    2395, 0,    1135, 0,    800,  337,  0,    0,    4292, 3378, 0,    4239,
    0,    37,   2292, 0,    0,    0,    1629, 0,    792,  0,    2073, 1096, 541,  0,    263,  1237,
    3719, 1463, 0,    0,    2130, 0,    1861, 512,  0,    853,  649,  2388, 1035, 1904, 0,    969,
    0,    1492, 615,  3658, 313,  340,  1217, 3502, 1555, 1407, 833,  999,  2591, 2118, 0,    704,
    4231, 0,    279,  0,    2642, 1822, 1715, 1707, 1030, 2920, 2567, 0,    0,    0,    0,    0,
    2900, 3155, 0,    3667, 1772, 2,    0,    1078, 2977, 0,    0,    0,    2729, 0,    1442, 0,
    0,    0,    0,    0,    3920, 0,    0,    3935, 0,    1268, 0,    0,    445,  1392, 1363, 0,
    0,    1065, 0,    488,  174,  3583, 2426, 1695, 0,    0,    1701, 947,  2725, 506,  1912, 0,
    0,    2584, 783,  0,    73,   63,   8,    0,    4059, 281,  0,    0,    0,    200,  1234, 0,
    0,    0,    2040, 0,    0,    491,  2550, 0,    270,  0,    0,    3633, 0,    545,  0,    1828,
    0,    2017, 776,  2246, 1943, 3754, 0,    1359, 3380, 1757, 0,    0,    1655, 0,    972,  0,
    820,  0,    721,  0,    902,  0,    4345, 139,  833,  0,    613,  3566, 2190, 1456, 4312, 0,
    0,    0,    0,    21,   0,    2853, 0,    0,    675,  2107, 0,    293,  0,    479,  0,    0,
    2196, 1468, 0,    0,    484,  0,    2156, 0,    946,  145,  1120, 1186, 0,    172,  1633, 1336,
    0,    0,    289,  3205, 0,    256,  593,  968,  0,    3951, 0,    1419, 2564, 2002, 0,    0,
    1740, 0,    0,    4287, 0,    1653, 1921, 570,  0,    1034, 0,    1124, 662,  0,    0,    1755,
    1400, 0,    0,    0,    316,  0,    0,    0,    1490, 0,    0,    0,    0,    0,    1541, 4087,
    0,    1393, 0,    948,  0,    4399, 1366, 0,    239,  0,    0,    4434, 0,    0,    247,  0,
    3410, 0,    677,  412,  3905, 0,    2360, 0,    3052, 0,    838,  1582, 0,    1221, 0,    0,
    0,    1453, 528,  2773, 0,    515,  0,    2112, 3720, 1068, 3636, 378,  0,    1726, 778,  4077,
    0,    0,    0,    55,   1311, 1115, 1243, 0,    0,    3736, 1583, 0,    2313, 1409, 213,  0,
    3382, 0,    0,    1182, 1514, 993,  853,  1962, 0,    0,    1307, 693,  0,    1299, 382,  0,
    843,  0,    0,    2964, 515,  1136, 0,    0,    0,    0,    0,    1064, 1333, 0,    1655, 3331,
    1533, 3489, 0,    1758, 2071, 51,   2062, 0,    0,    0,    3874, 4331, 2770, 0,    1815, 0,
    0,    3463, 0,    1133, 682,  3269, 0,    991,  685,  0,    1954, 4084, 435,  0,    270,  0,
    485,  4390, 1306, 0,    743,  192,  3816, 0,    0,    1694, 1547, 4004, 1444, 1348, 754,  345,
    0,    2231, 945,  1737, 2846, 0,    893,  1224, 664,  1978, 0,    410,  3665, 1977, 1389, 0,
    568,  0,    785,  938,  2869, 1699, 820,  0,    0,    14,   124,  0,    3984, 58,   0,    2133,
    0,    0,    4166, 0,    1983, 0,    0,    1672, 1835, 2693, 3941, 850,  0,    1504, 0,    0,
    0,    166,  2235, 3296, 0,    3197, 1921, 1293, 0,    789,  0,    0,    0,    0,    0,    0,
    735,  472,  2520, 657,  1893, 1044, 4135, 0,    1939, 551,  0,    0,    0,    0,    753,  0,
    0,    1206, 985,  0,    1472, 377,  218,  2261, 1553, 3987, 1622, 0,    4395, 2758, 1471, 4329,
    110,  1951, 308,  212,  312,  0,    3532, 1846, 1738, 0,    2034, 0,    1002, 248,  1935, 0,
    0,    1105, 0,    0,    4251, 315,  0,    167,  2505, 361,  0,    3188, 422,  0,    0,    0,
    0,    0,    0,    1639, 0,    1178, 1681, 3464, 1113, 962,  0,    0,    1164, 803,  807,  0,
    0,    0,    0,    0,    0,    0,    1541, 0,    0,    723,  0,    255,  0,    0,    196,  0,
    0,    1239, 4332, 0,    161,  0,    0,    0,    12,   663,  899,  1396, 0,    706,  3925, 3944,
    0,    1580, 580,  0,    770,  0,    0,    0,    1308, 0,    0,    3245, 0,    1509, 1581, 4074,
    796,  0,    67,   1991, 2099, 0,    0,    756,  1332, 0,    3100, 1685, 473,  0,    0,    3556,
    310,  1742, 0,    99,   0,    0,    0,    1615, 1045, 0,    0,    4293, 0,    0,    63,   1454,
    1201, 1423, 3959, 0,    0,    1550, 1409, 0,    338,  0,    0,    4084, 0,    0,    0,    0,
    1808, 0,    0,    544,  0,    2445, 1182, 1095, 45,   0,    2143, 0,    1297, 3930, 1618, 4262,
    271,  945,  2502, 0,    0,    3228, 0,    0,    1921, 0,    0,    0,    52,   1704, 510,  556,
    571,  0,    4124, 0,    2102, 3796, 0,    889,  0,    0,    44,   1938, 629,  224,  0,    0,
    0,    0,    385,  1554, 0,    2228, 139,  0,    627,  1972, 335,  62,   669,  1773, 0,    2083,
    1366, 0,    1471, 0,    498,  3988, 0,    522,  0,    205,  1606, 1757, 3023, 0,    1010, 564,
    107,  628,  1884, 0,    3461, 1369, 585,  0,    1725, 3483, 3024, 653,  4278, 1602, 889,  372,
    220,  1198, 460,  0,    1165, 0,    863,  0,    0,    0,    0,    496,  3563, 1046, 0,    0,
    0,    0,    1745, 1158, 2089, 125,  857,  0,    2195, 0,    619,  4298, 0,    0,    0,    732,
    313,  711,  0,    1694, 372,  0,    1326, 930,  4009, 1224, 0,    1090, 3888, 2008, 1390, 3070,
    2099, 2815, 3538, 3573, 1715, 4373, 0,    0,    1474, 1076, 2760, 1542, 0,    861,  0,    0,
    0,    0,    0,    944,  4203, 990,  3499, 0,    0,    177,  1642, 0,    1222, 0,    196,  3731,
    0,    0,    1858, 0,    0,    2971, 0,    678,  0,    3380, 601,  698,  2915, 3734, 0,    2065,
    0,    0,    2780, 1479, 0,    0,    1624, 0,    0,    0,    2957, 2660, 3970, 0,    196,  392,
    0,    754,  0,    0,    0,    0,    1601, 1405, 2884, 1413, 4185, 0,    1844, 104,  1007, 2054,
    0,    0,    700,  0,    336,  0,    3635, 202,  0,    0,    0,    1449, 798,  758,  522,  2544,
    0,    34,   0,    2092, 434,  146,  0,    0,    4294, 0,    4276, 863,  0,    3228, 0,    725,
    4420, 987,  0,    1882, 0,    1881, 3797, 1764, 2024, 2690, 0,    220,  0,    549,  1106, 505,
    1260, 0,    0,    2110, 3273, 0,    768,  2086, 0,    795,  3357, 4368, 142,  0,    3030, 10,
    1109, 1192, 0,    3817, 3209, 2265, 983,  170,  0,    0,    1582, 0,    0,    0,    480,  943,
    0,    1295, 1216, 1460, 1193, 0,    0,    368,  1386, 3889, 764,  0,    1310, 0,    2126, 1118,
    1355, 0,    1486, 1056, 2964, 1596, 4059, 0,    0,    2131, 3414, 29,   910,  555,  1830, 982,
    2894, 3557, 0,    2950, 2127, 2982, 360,  0,    0,    1204, 0,    1170, 0,    0,    1242, 282,
    1052, 1942, 0,    2124, 0,    289,  511,  527,  0,    0,    4314, 3611, 0,    911,  1100, 0,
    118,  479,  1874, 3541, 344,  259,  3202, 0,    3182, 127,  1813, 1476, 0,    0,    0,    0,
    2944, 468,  0,    521,  0,    578,  0,    808,  0,    450,  1054, 425,  850,  1197, 0,    715,
    0,    1203, 4109, 2110, 0,    0,    1093, 0,    2023, 760,  1473, 0,    0,    1944, 0,    72,
    0,    1519, 1,    3083, 440,  1294, 671,  739,  4179, 1407, 0,    0,    3482, 1356, 1345, 2094,
    0,    209,  732,  0,    1134, 1230, 3570, 1386, 1806, 424,  302,  1604, 662,  2635, 0,    0,
    1469, 0,    820,  0,    1600, 0,    47,   894,  1388, 4282, 0,    855,  2659, 0,    2707, 3184,
    3384, 0,    0,    47,   0,    0,    1454, 1646, 958,  4262, 0,    0,    0,    1630, 0,    0,
    0,    3738, 2920, 0,    2965, 0,    362,  0,    0,    0,    1026, 0,    547,  4297, 1897, 973,
    1775, 0,    3494, 2714, 3430, 852,  1497, 1432, 0,    4150, 2123, 40,   1254, 697,  912,  0,
    4211, 0,    878,  0,    1346};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 4437;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 37)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 4437;
}

constexpr int unmangledkT1[] = {162, 98,  200, 17, 263, 137, 354, 364, 24,  149, 40,  40,  170,
                                267, 387, 255, 7,  55,  108, 152, 27,  154, 105, 349, 229, 229};
constexpr int unmangledkT2[] = {290, 338, 301, 284, 117, 303, 83,  150, 389, 350, 323, 330, 58,
                                316, 310, 107, 30,  65,  14,  310, 8,   298, 365, 40,  174, 83};
constexpr int unmangledkG[]  = {
    0,   0,   0,   0,   0,   15,  0,   0,   0,   0,   0,   0,   0,   0,   199, 165, 0,   0,   0,
    0,   0,   231, 244, 164, 0,   0,   71,  381, 37,  0,   0,   138, 9,   33,  0,   6,   0,   0,
    163, 102, 0,   0,   152, 0,   70,  0,   0,   203, 0,   181, 0,   0,   206, 0,   0,   0,   0,
    0,   0,   0,   40,  0,   0,   119, 0,   0,   122, 0,   116, 0,   66,  0,   92,  116, 0,   355,
    101, 0,   0,   0,   70,  0,   0,   0,   78,  366, 0,   28,  383, 0,   0,   273, 0,   392, 0,
    0,   0,   369, 325, 0,   74,  0,   0,   260, 0,   0,   0,   306, 306, 0,   68,  0,   123, 61,
    0,   140, 190, 0,   0,   0,   165, 88,  73,  0,   379, 17,  81,  82,  360, 0,   170, 28,  120,
    0,   0,   0,   0,   315, 58,  56,  0,   393, 50,  0,   0,   392, 48,  305, 0,   0,   384, 24,
    0,   381, 0,   0,   0,   74,  0,   0,   227, 0,   0,   160, 174, 0,   0,   0,   0,   0,   0,
    0,   0,   192, 0,   59,  0,   0,   0,   225, 327, 0,   75,  142, 367, 0,   0,   107, 0,   0,
    48,  0,   0,   66,  47,  0,   0,   0,   228, 341, 58,  0,   196, 40,  130, 25,  41,  179, 136,
    3,   0,   115, 373, 0,   0,   311, 31,  0,   0,   0,   349, 113, 62,  89,  0,   21,  0,   21,
    24,  76,  378, 0,   390, 0,   140, 123, 0,   0,   0,   0,   2,   322, 151, 382, 112, 0,   19,
    273, 137, 0,   0,   69,  23,  0,   0,   160, 0,   39,  26,  269, 362, 0,   186, 0,   109, 62,
    82,  0,   57,  37,  0,   155, 64,  399, 146, 191, 0,   0,   282, 0,   0,   163, 392, 153, 192,
    127, 0,   98,  0,   72,  0,   0,   128, 24,  396, 0,   41,  71,  0,   0,   17,  133, 0,   381,
    180, 310, 115, 124, 166, 7,   0,   0,   0,   0,   81,  295, 369, 0,   230, 134, 86,  0,   121,
    0,   0,   206, 0,   0,   188, 85,  230, 197, 118, 0,   0,   10,  394, 59,  96,  0,   371, 53,
    0,   369, 0,   364, 0,   209, 0,   178, 195, 228, 0,   0,   0,   0,   0,   0,   0,   167, 41,
    89,  0,   76,  0,   172, 0,   0,   176, 0,   48,  0,   198, 0,   265, 56,  157, 0,   283, 0,
    102, 217, 0,   0,   0,   38,  146, 0,   112, 0,   41,  0,   0,   0,   200, 0,   19,  43,  0,
    82,  396, 57};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 402;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 26)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 402;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
